/*
 * Copyright 2021 NXP
 * SPDX-License-Identifier: BSD-3-Clause
 */

#if !defined(PHY_H) && defined(NXP_WARM_BOOT)
#define PHY_H

#include <flash_info.h>

/* To store sector size to be erase on flash*/
#define PHY_ERASE_SIZE F_SECTOR_ERASE_SZ

/*Structure to implement address-data map tuples to store PHY training values*/
struct phy_training_values {
	uint32_t addr;
	uint16_t data;
};
/* Saves PHY Training Register values after cold reset
 *@param[in] phy_ptr array to store addresses of PHYs
 *@param[in] address_to_store address to save PHY training register values
 *on flash
 *@param[in] num_of_phy the number of PHY for which training values are
 *to be saved
 *@param[in] train2d flag to store whether 2D training registers are to
 *be saved or not
 *
 *PHY training values will be stored on flash at contigous memory in the order:
 *1D training registers, 2D training registers
 *for each PHY
 *
 *if train2d is false saving 2D training registers will be skipped
 */
int save_phy_training_values(uint16_t **phy_ptr, uint32_t address_to_store,
		uint32_t num_of_phy, int train2d);

/*Restores PHY Training Register values after warm reset
 *@param[in] phy_ptr array to store addresses of PHYs
 *@param[in] address_to_store address to retrieve PHY training register
 *values from flash
 *@param[in] num_of_phy the number of PHY for which training values are
 *to be restored
 *@param[in] train2d flag to store whether 2D training registers are
 *to be restored or not
 *
 *if train2d is false saving 2D training registers will be skipped
 */

int restore_phy_training_values(uint16_t **phy_ptr, uint32_t address_to_restore,
		uint32_t num_of_phy, int train2d);

/*
 * Address data tuples to store the PHY 1D
 */

struct phy_training_values training_1D_values[] = {
	{0x200B2, 0},	{0x200CB, 0},	{0x10043, 0},	{0x11043, 0},
	{0x12043, 0},	{0x13043, 0},	{0x14043, 0},	{0x15043, 0},
	{0x16043, 0},	{0x17043, 0},	{0x18043, 0},	{0x10143, 0},
	{0x11143, 0},	{0x12143, 0},	{0x13143, 0},	{0x14143, 0},
	{0x15143, 0},	{0x16143, 0},	{0x17143, 0},	{0x18143, 0},
	{0x10080, 0},	{0x11080, 0},	{0x12080, 0},	{0x13080, 0},
	{0x14080, 0},	{0x15080, 0},	{0x16080, 0},	{0x17080, 0},
	{0x18080, 0},	{0x10180, 0},	{0x11180, 0},	{0x12180, 0},
	{0x13180, 0},	{0x14180, 0},	{0x15180, 0},	{0x16180, 0},
	{0x17180, 0},	{0x18180, 0},	{0x10081, 0},	{0x11081, 0},
	{0x12081, 0},	{0x13081, 0},	{0x14081, 0},	{0x15081, 0},
	{0x16081, 0},	{0x17081, 0},	{0x18081, 0},	{0x10181, 0},
	{0x11181, 0},	{0x12181, 0},	{0x13181, 0},	{0x14181, 0},
	{0x15181, 0},	{0x16181, 0},	{0x17181, 0},	{0x18181, 0},
	{0x10082, 0},	{0x11082, 0},	{0x12082, 0},	{0x13082, 0},
	{0x14082, 0},	{0x15082, 0},	{0x16082, 0},	{0x17082, 0},
	{0x18082, 0},	{0x10182, 0},	{0x11182, 0},	{0x12182, 0},
	{0x13182, 0},	{0x14182, 0},	{0x15182, 0},	{0x16182, 0},
	{0x17182, 0},	{0x18182, 0},	{0x10083, 0},	{0x11083, 0},
	{0x12083, 0},	{0x13083, 0},	{0x14083, 0},	{0x15083, 0},
	{0x16083, 0},	{0x17083, 0},	{0x18083, 0},	{0x10183, 0},
	{0x11183, 0},	{0x12183, 0},	{0x13183, 0},	{0x14183, 0},
	{0x15183, 0},	{0x16183, 0},	{0x17183, 0},	{0x18183, 0},
	{0x100D0, 0},	{0x110D0, 0},	{0x120D0, 0},	{0x130D0, 0},
	{0x140D0, 0},	{0x150D0, 0},	{0x160D0, 0},	{0x170D0, 0},
	{0x180D0, 0},	{0x101D0, 0},	{0x111D0, 0},	{0x121D0, 0},
	{0x131D0, 0},	{0x141D0, 0},	{0x151D0, 0},	{0x161D0, 0},
	{0x171D0, 0},	{0x181D0, 0},	{0x100D1, 0},	{0x110D1, 0},
	{0x120D1, 0},	{0x130D1, 0},	{0x140D1, 0},	{0x150D1, 0},
	{0x160D1, 0},	{0x170D1, 0},	{0x180D1, 0},	{0x101D1, 0},
	{0x111D1, 0},	{0x121D1, 0},	{0x131D1, 0},	{0x141D1, 0},
	{0x151D1, 0},	{0x161D1, 0},	{0x171D1, 0},	{0x181D1, 0},
	{0x100D2, 0},	{0x110D2, 0},	{0x120D2, 0},	{0x130D2, 0},
	{0x140D2, 0},	{0x150D2, 0},	{0x160D2, 0},	{0x170D2, 0},
	{0x180D2, 0},	{0x101D2, 0},	{0x111D2, 0},	{0x121D2, 0},
	{0x131D2, 0},	{0x141D2, 0},	{0x151D2, 0},	{0x161D2, 0},
	{0x171D2, 0},	{0x181D2, 0},	{0x100D3, 0},	{0x110D3, 0},
	{0x120D3, 0},	{0x130D3, 0},	{0x140D3, 0},	{0x150D3, 0},
	{0x160D3, 0},	{0x170D3, 0},	{0x180D3, 0},	{0x101D3, 0},
	{0x111D3, 0},	{0x121D3, 0},	{0x131D3, 0},	{0x141D3, 0},
	{0x151D3, 0},	{0x161D3, 0},	{0x171D3, 0},	{0x181D3, 0},
	{0x10068, 0},	{0x11068, 0},	{0x12068, 0},	{0x13068, 0},
	{0x14068, 0},	{0x15068, 0},	{0x16068, 0},	{0x17068, 0},
	{0x18068, 0},	{0x10168, 0},	{0x11168, 0},	{0x12168, 0},
	{0x13168, 0},	{0x14168, 0},	{0x15168, 0},	{0x16168, 0},
	{0x17168, 0},	{0x18168, 0},	{0x10268, 0},	{0x11268, 0},
	{0x12268, 0},	{0x13268, 0},	{0x14268, 0},	{0x15268, 0},
	{0x16268, 0},	{0x17268, 0},	{0x18268, 0},	{0x10368, 0},
	{0x11368, 0},	{0x12368, 0},	{0x13368, 0},	{0x14368, 0},
	{0x15368, 0},	{0x16368, 0},	{0x17368, 0},	{0x18368, 0},
	{0x10468, 0},	{0x11468, 0},	{0x12468, 0},	{0x13468, 0},
	{0x14468, 0},	{0x15468, 0},	{0x16468, 0},	{0x17468, 0},
	{0x18468, 0},	{0x10568, 0},	{0x11568, 0},	{0x12568, 0},
	{0x13568, 0},	{0x14568, 0},	{0x15568, 0},	{0x16568, 0},
	{0x17568, 0},	{0x18568, 0},	{0x10668, 0},	{0x11668, 0},
	{0x12668, 0},	{0x13668, 0},	{0x14668, 0},	{0x15668, 0},
	{0x16668, 0},	{0x17668, 0},	{0x18668, 0},	{0x10768, 0},
	{0x11768, 0},	{0x12768, 0},	{0x13768, 0},	{0x14768, 0},
	{0x15768, 0},	{0x16768, 0},	{0x17768, 0},	{0x18768, 0},
	{0x10868, 0},	{0x11868, 0},	{0x12868, 0},	{0x13868, 0},
	{0x14868, 0},	{0x15868, 0},	{0x16868, 0},	{0x17868, 0},
	{0x18868, 0},	{0x10069, 0},	{0x11069, 0},	{0x12069, 0},
	{0x13069, 0},	{0x14069, 0},	{0x15069, 0},	{0x16069, 0},
	{0x17069, 0},	{0x18069, 0},	{0x10169, 0},	{0x11169, 0},
	{0x12169, 0},	{0x13169, 0},	{0x14169, 0},	{0x15169, 0},
	{0x16169, 0},	{0x17169, 0},	{0x18169, 0},	{0x10269, 0},
	{0x11269, 0},	{0x12269, 0},	{0x13269, 0},	{0x14269, 0},
	{0x15269, 0},	{0x16269, 0},	{0x17269, 0},	{0x18269, 0},
	{0x10369, 0},	{0x11369, 0},	{0x12369, 0},	{0x13369, 0},
	{0x14369, 0},	{0x15369, 0},	{0x16369, 0},	{0x17369, 0},
	{0x18369, 0},	{0x10469, 0},	{0x11469, 0},	{0x12469, 0},
	{0x13469, 0},	{0x14469, 0},	{0x15469, 0},	{0x16469, 0},
	{0x17469, 0},	{0x18469, 0},	{0x10569, 0},	{0x11569, 0},
	{0x12569, 0},	{0x13569, 0},	{0x14569, 0},	{0x15569, 0},
	{0x16569, 0},	{0x17569, 0},	{0x18569, 0},	{0x10669, 0},
	{0x11669, 0},	{0x12669, 0},	{0x13669, 0},	{0x14669, 0},
	{0x15669, 0},	{0x16669, 0},	{0x17669, 0},	{0x18669, 0},
	{0x10769, 0},	{0x11769, 0},	{0x12769, 0},	{0x13769, 0},
	{0x14769, 0},	{0x15769, 0},	{0x16769, 0},	{0x17769, 0},
	{0x18769, 0},	{0x10869, 0},	{0x11869, 0},	{0x12869, 0},
	{0x13869, 0},	{0x14869, 0},	{0x15869, 0},	{0x16869, 0},
	{0x17869, 0},	{0x18869, 0},	{0x1006A, 0},	{0x1106A, 0},
	{0x1206A, 0},	{0x1306A, 0},	{0x1406A, 0},	{0x1506A, 0},
	{0x1606A, 0},	{0x1706A, 0},	{0x1806A, 0},	{0x1016A, 0},
	{0x1116A, 0},	{0x1216A, 0},	{0x1316A, 0},	{0x1416A, 0},
	{0x1516A, 0},	{0x1616A, 0},	{0x1716A, 0},	{0x1816A, 0},
	{0x1026A, 0},	{0x1126A, 0},	{0x1226A, 0},	{0x1326A, 0},
	{0x1426A, 0},	{0x1526A, 0},	{0x1626A, 0},	{0x1726A, 0},
	{0x1826A, 0},	{0x1036A, 0},	{0x1136A, 0},	{0x1236A, 0},
	{0x1336A, 0},	{0x1436A, 0},	{0x1536A, 0},	{0x1636A, 0},
	{0x1736A, 0},	{0x1836A, 0},	{0x1046A, 0},	{0x1146A, 0},
	{0x1246A, 0},	{0x1346A, 0},	{0x1446A, 0},	{0x1546A, 0},
	{0x1646A, 0},	{0x1746A, 0},	{0x1846A, 0},	{0x1056A, 0},
	{0x1156A, 0},	{0x1256A, 0},	{0x1356A, 0},	{0x1456A, 0},
	{0x1556A, 0},	{0x1656A, 0},	{0x1756A, 0},	{0x1856A, 0},
	{0x1066A, 0},	{0x1166A, 0},	{0x1266A, 0},	{0x1366A, 0},
	{0x1466A, 0},	{0x1566A, 0},	{0x1666A, 0},	{0x1766A, 0},
	{0x1866A, 0},	{0x1076A, 0},	{0x1176A, 0},	{0x1276A, 0},
	{0x1376A, 0},	{0x1476A, 0},	{0x1576A, 0},	{0x1676A, 0},
	{0x1776A, 0},	{0x1876A, 0},	{0x1086A, 0},	{0x1186A, 0},
	{0x1286A, 0},	{0x1386A, 0},	{0x1486A, 0},	{0x1586A, 0},
	{0x1686A, 0},	{0x1786A, 0},	{0x1886A, 0},	{0x1006B, 0},
	{0x1106B, 0},	{0x1206B, 0},	{0x1306B, 0},	{0x1406B, 0},
	{0x1506B, 0},	{0x1606B, 0},	{0x1706B, 0},	{0x1806B, 0},
	{0x1016B, 0},	{0x1116B, 0},	{0x1216B, 0},	{0x1316B, 0},
	{0x1416B, 0},	{0x1516B, 0},	{0x1616B, 0},	{0x1716B, 0},
	{0x1816B, 0},	{0x1026B, 0},	{0x1126B, 0},	{0x1226B, 0},
	{0x1326B, 0},	{0x1426B, 0},	{0x1526B, 0},	{0x1626B, 0},
	{0x1726B, 0},	{0x1826B, 0},	{0x1036B, 0},	{0x1136B, 0},
	{0x1236B, 0},	{0x1336B, 0},	{0x1436B, 0},	{0x1536B, 0},
	{0x1636B, 0},	{0x1736B, 0},	{0x1836B, 0},	{0x1046B, 0},
	{0x1146B, 0},	{0x1246B, 0},	{0x1346B, 0},	{0x1446B, 0},
	{0x1546B, 0},	{0x1646B, 0},	{0x1746B, 0},	{0x1846B, 0},
	{0x1056B, 0},	{0x1156B, 0},	{0x1256B, 0},	{0x1356B, 0},
	{0x1456B, 0},	{0x1556B, 0},	{0x1656B, 0},	{0x1756B, 0},
	{0x1856B, 0},	{0x1066B, 0},	{0x1166B, 0},	{0x1266B, 0},
	{0x1366B, 0},	{0x1466B, 0},	{0x1566B, 0},	{0x1666B, 0},
	{0x1766B, 0},	{0x1866B, 0},	{0x1076B, 0},	{0x1176B, 0},
	{0x1276B, 0},	{0x1376B, 0},	{0x1476B, 0},	{0x1576B, 0},
	{0x1676B, 0},	{0x1776B, 0},	{0x1876B, 0},	{0x1086B, 0},
	{0x1186B, 0},	{0x1286B, 0},	{0x1386B, 0},	{0x1486B, 0},
	{0x1586B, 0},	{0x1686B, 0},	{0x1786B, 0},	{0x1886B, 0},
	{0x1008C, 0},	{0x1108C, 0},	{0x1208C, 0},	{0x1308C, 0},
	{0x1408C, 0},	{0x1508C, 0},	{0x1608C, 0},	{0x1708C, 0},
	{0x1808C, 0},	{0x1018C, 0},	{0x1118C, 0},	{0x1218C, 0},
	{0x1318C, 0},	{0x1418C, 0},	{0x1518C, 0},	{0x1618C, 0},
	{0x1718C, 0},	{0x1818C, 0},	{0x1008D, 0},	{0x1108D, 0},
	{0x1208D, 0},	{0x1308D, 0},	{0x1408D, 0},	{0x1508D, 0},
	{0x1608D, 0},	{0x1708D, 0},	{0x1808D, 0},	{0x1018D, 0},
	{0x1118D, 0},	{0x1218D, 0},	{0x1318D, 0},	{0x1418D, 0},
	{0x1518D, 0},	{0x1618D, 0},	{0x1718D, 0},	{0x1818D, 0},
	{0x1008E, 0},	{0x1108E, 0},	{0x1208E, 0},	{0x1308E, 0},
	{0x1408E, 0},	{0x1508E, 0},	{0x1608E, 0},	{0x1708E, 0},
	{0x1808E, 0},	{0x1018E, 0},	{0x1118E, 0},	{0x1218E, 0},
	{0x1318E, 0},	{0x1418E, 0},	{0x1518E, 0},	{0x1618E, 0},
	{0x1718E, 0},	{0x1818E, 0},	{0x1008F, 0},	{0x1108F, 0},
	{0x1208F, 0},	{0x1308F, 0},	{0x1408F, 0},	{0x1508F, 0},
	{0x1608F, 0},	{0x1708F, 0},	{0x1808F, 0},	{0x1018F, 0},
	{0x1118F, 0},	{0x1218F, 0},	{0x1318F, 0},	{0x1418F, 0},
	{0x1518F, 0},	{0x1618F, 0},	{0x1718F, 0},	{0x1818F, 0},
	{0x100C0, 0},	{0x110C0, 0},	{0x120C0, 0},	{0x130C0, 0},
	{0x140C0, 0},	{0x150C0, 0},	{0x160C0, 0},	{0x170C0, 0},
	{0x180C0, 0},	{0x101C0, 0},	{0x111C0, 0},	{0x121C0, 0},
	{0x131C0, 0},	{0x141C0, 0},	{0x151C0, 0},	{0x161C0, 0},
	{0x171C0, 0},	{0x181C0, 0},	{0x102C0, 0},	{0x112C0, 0},
	{0x122C0, 0},	{0x132C0, 0},	{0x142C0, 0},	{0x152C0, 0},
	{0x162C0, 0},	{0x172C0, 0},	{0x182C0, 0},	{0x103C0, 0},
	{0x113C0, 0},	{0x123C0, 0},	{0x133C0, 0},	{0x143C0, 0},
	{0x153C0, 0},	{0x163C0, 0},	{0x173C0, 0},	{0x183C0, 0},
	{0x104C0, 0},	{0x114C0, 0},	{0x124C0, 0},	{0x134C0, 0},
	{0x144C0, 0},	{0x154C0, 0},	{0x164C0, 0},	{0x174C0, 0},
	{0x184C0, 0},	{0x105C0, 0},	{0x115C0, 0},	{0x125C0, 0},
	{0x135C0, 0},	{0x145C0, 0},	{0x155C0, 0},	{0x165C0, 0},
	{0x175C0, 0},	{0x185C0, 0},	{0x106C0, 0},	{0x116C0, 0},
	{0x126C0, 0},	{0x136C0, 0},	{0x146C0, 0},	{0x156C0, 0},
	{0x166C0, 0},	{0x176C0, 0},	{0x186C0, 0},	{0x107C0, 0},
	{0x117C0, 0},	{0x127C0, 0},	{0x137C0, 0},	{0x147C0, 0},
	{0x157C0, 0},	{0x167C0, 0},	{0x177C0, 0},	{0x187C0, 0},
	{0x108C0, 0},	{0x118C0, 0},	{0x128C0, 0},	{0x138C0, 0},
	{0x148C0, 0},	{0x158C0, 0},	{0x168C0, 0},	{0x178C0, 0},
	{0x188C0, 0},	{0x100C1, 0},	{0x110C1, 0},	{0x120C1, 0},
	{0x130C1, 0},	{0x140C1, 0},	{0x150C1, 0},	{0x160C1, 0},
	{0x170C1, 0},	{0x180C1, 0},	{0x101C1, 0},	{0x111C1, 0},
	{0x121C1, 0},	{0x131C1, 0},	{0x141C1, 0},	{0x151C1, 0},
	{0x161C1, 0},	{0x171C1, 0},	{0x181C1, 0},	{0x102C1, 0},
	{0x112C1, 0},	{0x122C1, 0},	{0x132C1, 0},	{0x142C1, 0},
	{0x152C1, 0},	{0x162C1, 0},	{0x172C1, 0},	{0x182C1, 0},
	{0x103C1, 0},	{0x113C1, 0},	{0x123C1, 0},	{0x133C1, 0},
	{0x143C1, 0},	{0x153C1, 0},	{0x163C1, 0},	{0x173C1, 0},
	{0x183C1, 0},	{0x104C1, 0},	{0x114C1, 0},	{0x124C1, 0},
	{0x134C1, 0},	{0x144C1, 0},	{0x154C1, 0},	{0x164C1, 0},
	{0x174C1, 0},	{0x184C1, 0},	{0x105C1, 0},	{0x115C1, 0},
	{0x125C1, 0},	{0x135C1, 0},	{0x145C1, 0},	{0x155C1, 0},
	{0x165C1, 0},	{0x175C1, 0},	{0x185C1, 0},	{0x106C1, 0},
	{0x116C1, 0},	{0x126C1, 0},	{0x136C1, 0},	{0x146C1, 0},
	{0x156C1, 0},	{0x166C1, 0},	{0x176C1, 0},	{0x186C1, 0},
	{0x107C1, 0},	{0x117C1, 0},	{0x127C1, 0},	{0x137C1, 0},
	{0x147C1, 0},	{0x157C1, 0},	{0x167C1, 0},	{0x177C1, 0},
	{0x187C1, 0},	{0x108C1, 0},	{0x118C1, 0},	{0x128C1, 0},
	{0x138C1, 0},	{0x148C1, 0},	{0x158C1, 0},	{0x168C1, 0},
	{0x178C1, 0},	{0x188C1, 0},	{0x100C2, 0},	{0x110C2, 0},
	{0x120C2, 0},	{0x130C2, 0},	{0x140C2, 0},	{0x150C2, 0},
	{0x160C2, 0},	{0x170C2, 0},	{0x180C2, 0},	{0x101C2, 0},
	{0x111C2, 0},	{0x121C2, 0},	{0x131C2, 0},	{0x141C2, 0},
	{0x151C2, 0},	{0x161C2, 0},	{0x171C2, 0},	{0x181C2, 0},
	{0x102C2, 0},	{0x112C2, 0},	{0x122C2, 0},	{0x132C2, 0},
	{0x142C2, 0},	{0x152C2, 0},	{0x162C2, 0},	{0x172C2, 0},
	{0x182C2, 0},	{0x103C2, 0},	{0x113C2, 0},	{0x123C2, 0},
	{0x133C2, 0},	{0x143C2, 0},	{0x153C2, 0},	{0x163C2, 0},
	{0x173C2, 0},	{0x183C2, 0},	{0x104C2, 0},	{0x114C2, 0},
	{0x124C2, 0},	{0x134C2, 0},	{0x144C2, 0},	{0x154C2, 0},
	{0x164C2, 0},	{0x174C2, 0},	{0x184C2, 0},	{0x105C2, 0},
	{0x115C2, 0},	{0x125C2, 0},	{0x135C2, 0},	{0x145C2, 0},
	{0x155C2, 0},	{0x165C2, 0},	{0x175C2, 0},	{0x185C2, 0},
	{0x106C2, 0},	{0x116C2, 0},	{0x126C2, 0},	{0x136C2, 0},
	{0x146C2, 0},	{0x156C2, 0},	{0x166C2, 0},	{0x176C2, 0},
	{0x186C2, 0},	{0x107C2, 0},	{0x117C2, 0},	{0x127C2, 0},
	{0x137C2, 0},	{0x147C2, 0},	{0x157C2, 0},	{0x167C2, 0},
	{0x177C2, 0},	{0x187C2, 0},	{0x108C2, 0},	{0x118C2, 0},
	{0x128C2, 0},	{0x138C2, 0},	{0x148C2, 0},	{0x158C2, 0},
	{0x168C2, 0},	{0x178C2, 0},	{0x188C2, 0},	{0x100C3, 0},
	{0x110C3, 0},	{0x120C3, 0},	{0x130C3, 0},	{0x140C3, 0},
	{0x150C3, 0},	{0x160C3, 0},	{0x170C3, 0},	{0x180C3, 0},
	{0x101C3, 0},	{0x111C3, 0},	{0x121C3, 0},	{0x131C3, 0},
	{0x141C3, 0},	{0x151C3, 0},	{0x161C3, 0},	{0x171C3, 0},
	{0x181C3, 0},	{0x102C3, 0},	{0x112C3, 0},	{0x122C3, 0},
	{0x132C3, 0},	{0x142C3, 0},	{0x152C3, 0},	{0x162C3, 0},
	{0x172C3, 0},	{0x182C3, 0},	{0x103C3, 0},	{0x113C3, 0},
	{0x123C3, 0},	{0x133C3, 0},	{0x143C3, 0},	{0x153C3, 0},
	{0x163C3, 0},	{0x173C3, 0},	{0x183C3, 0},	{0x104C3, 0},
	{0x114C3, 0},	{0x124C3, 0},	{0x134C3, 0},	{0x144C3, 0},
	{0x154C3, 0},	{0x164C3, 0},	{0x174C3, 0},	{0x184C3, 0},
	{0x105C3, 0},	{0x115C3, 0},	{0x125C3, 0},	{0x135C3, 0},
	{0x145C3, 0},	{0x155C3, 0},	{0x165C3, 0},	{0x175C3, 0},
	{0x185C3, 0},	{0x106C3, 0},	{0x116C3, 0},	{0x126C3, 0},
	{0x136C3, 0},	{0x146C3, 0},	{0x156C3, 0},	{0x166C3, 0},
	{0x176C3, 0},	{0x186C3, 0},	{0x107C3, 0},	{0x117C3, 0},
	{0x127C3, 0},	{0x137C3, 0},	{0x147C3, 0},	{0x157C3, 0},
	{0x167C3, 0},	{0x177C3, 0},	{0x187C3, 0},	{0x108C3, 0},
	{0x118C3, 0},	{0x128C3, 0},	{0x138C3, 0},	{0x148C3, 0},
	{0x158C3, 0},	{0x168C3, 0},	{0x178C3, 0},	{0x188C3, 0},
	{0x10020, 0},	{0x11020, 0},	{0x12020, 0},	{0x13020, 0},
	{0x14020, 0},	{0x15020, 0},	{0x16020, 0},	{0x17020, 0},
	{0x18020, 0},	{0x2007D, 0},	{0x20077, 0}
};

/*
 *Array to store the PHY 2D Training register addresses
 */
struct phy_training_values training_2D_values[] = {
	{0x1008C, 0},   {0x1108C, 0},   {0x1208C, 0},   {0x1308C, 0},
	{0x1408C, 0},   {0x1508C, 0},   {0x1608C, 0},   {0x1708C, 0},
	{0x1808C, 0},   {0x1018C, 0},   {0x1118C, 0},   {0x1218C, 0},
	{0x1318C, 0},   {0x1418C, 0},   {0x1518C, 0},   {0x1618C, 0},
	{0x1718C, 0},   {0x1818C, 0},   {0x10040, 0},   {0x11040, 0},
	{0x12040, 0},   {0x13040, 0},   {0x14040, 0},   {0x15040, 0},
	{0x16040, 0},   {0x17040, 0},   {0x18040, 0},   {0x10140, 0},
	{0x11140, 0},   {0x12140, 0},   {0x13140, 0},   {0x14140, 0},
	{0x15140, 0},   {0x16140, 0},   {0x17140, 0},   {0x18140, 0},
	{0x10240, 0},   {0x11240, 0},   {0x12240, 0},   {0x13240, 0},
	{0x14240, 0},   {0x15240, 0},   {0x16240, 0},   {0x17240, 0},
	{0x18240, 0},   {0x10340, 0},   {0x11340, 0},   {0x12340, 0},
	{0x13340, 0},   {0x14340, 0},   {0x15340, 0},   {0x16340, 0},
	{0x17340, 0},   {0x18340, 0},   {0x10440, 0},   {0x11440, 0},
	{0x12440, 0},   {0x13440, 0},   {0x14440, 0},   {0x15440, 0},
	{0x16440, 0},   {0x17440, 0},   {0x18440, 0},   {0x10540, 0},
	{0x11540, 0},   {0x12540, 0},   {0x13540, 0},   {0x14540, 0},
	{0x15540, 0},   {0x16540, 0},   {0x17540, 0},   {0x18540, 0},
	{0x10640, 0},   {0x11640, 0},   {0x12640, 0},   {0x13640, 0},
	{0x14640, 0},   {0x15640, 0},   {0x16640, 0},   {0x17640, 0},
	{0x18640, 0},   {0x10740, 0},   {0x11740, 0},   {0x12740, 0},
	{0x13740, 0},   {0x14740, 0},   {0x15740, 0},   {0x16740, 0},
	{0x17740, 0},   {0x18740, 0},   {0x10840, 0},   {0x11840, 0},
	{0x12840, 0},   {0x13840, 0},   {0x14840, 0},   {0x15840, 0},
	{0x16840, 0},   {0x17840, 0},   {0x18840, 0},   {0x10030, 0},
	{0x11030, 0},   {0x12030, 0},   {0x13030, 0},   {0x14030, 0},
	{0x15030, 0},   {0x16030, 0},   {0x17030, 0},   {0x18030, 0},
	{0x10130, 0},   {0x11130, 0},   {0x12130, 0},   {0x13130, 0},
	{0x14130, 0},   {0x15130, 0},   {0x16130, 0},   {0x17130, 0},
	{0x18130, 0},   {0x10230, 0},   {0x11230, 0},   {0x12230, 0},
	{0x13230, 0},   {0x14230, 0},   {0x15230, 0},   {0x16230, 0},
	{0x17230, 0},   {0x18230, 0},   {0x10330, 0},   {0x11330, 0},
	{0x12330, 0},   {0x13330, 0},   {0x14330, 0},   {0x15330, 0},
	{0x16330, 0},   {0x17330, 0},   {0x18330, 0},   {0x10430, 0},
	{0x11430, 0},   {0x12430, 0},   {0x13430, 0},   {0x14430, 0},
	{0x15430, 0},   {0x16430, 0},   {0x17430, 0},   {0x18430, 0},
	{0x10530, 0},   {0x11530, 0},   {0x12530, 0},   {0x13530, 0},
	{0x14530, 0},   {0x15530, 0},   {0x16530, 0},   {0x17530, 0},
	{0x18530, 0},   {0x10630, 0},   {0x11630, 0},   {0x12630, 0},
	{0x13630, 0},   {0x14630, 0},   {0x15630, 0},   {0x16630, 0},
	{0x17630, 0},   {0x18630, 0},   {0x10730, 0},   {0x11730, 0},
	{0x12730, 0},   {0x13730, 0},   {0x14730, 0},   {0x15730, 0},
	{0x16730, 0},   {0x17730, 0},   {0x18730, 0},   {0x10830, 0},
	{0x11830, 0},   {0x12830, 0},   {0x13830, 0},   {0x14830, 0},
	{0x15830, 0},   {0x16830, 0},   {0x17830, 0},   {0x18830, 0}
};

#endif
