/*
 * Copyright (c) 2015-2019, Renesas Electronics Corporation. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include <stdint.h>

#include <common/debug.h>

#include "../qos_common.h"
#include "../qos_reg.h"
#include "qos_init_m3_v10.h"

#define	RCAR_QOS_VERSION		"rev.0.19"

#if RCAR_QOS_TYPE  == RCAR_QOS_TYPE_DEFAULT
static const mstat_slot_t mstat_fix[] = {
	{0x0000U, 0x0000000000000000UL},
	{0x0008U, 0x0000000000000000UL},
	{0x0010U, 0x0000000000000000UL},
	{0x0018U, 0x0000000000000000UL},
	{0x0020U, 0x0000000000000000UL},
	{0x0028U, 0x0000000000000000UL},
	{0x0030U, 0x001004030000FFFFUL},
	{0x0038U, 0x001004030000FFFFUL},
	{0x0040U, 0x001414090000FFFFUL},
	{0x0048U, 0x0000000000000000UL},
	{0x0050U, 0x001410010000FFFFUL},
	{0x0058U, 0x00140C090000FFFFUL},
	{0x0060U, 0x00140C090000FFFFUL},
	{0x0068U, 0x0000000000000000UL},
	{0x0070U, 0x001410010000FFFFUL},
	{0x0078U, 0x001004020000FFFFUL},
	{0x0080U, 0x0000000000000000UL},
	{0x0088U, 0x001414090000FFFFUL},
	{0x0090U, 0x001408060000FFFFUL},
	{0x0098U, 0x0000000000000000UL},
	{0x00A0U, 0x000C08020000FFFFUL},
	{0x00A8U, 0x000C04010000FFFFUL},
	{0x00B0U, 0x000C04010000FFFFUL},
	{0x00B8U, 0x0000000000000000UL},
	{0x00C0U, 0x000C08020000FFFFUL},
	{0x00C8U, 0x000C04010000FFFFUL},
	{0x00D0U, 0x000C04010000FFFFUL},
	{0x00D8U, 0x000C04030000FFFFUL},
	{0x00E0U, 0x000C100F0000FFFFUL},
	{0x00E8U, 0x0000000000000000UL},
	{0x00F0U, 0x001010080000FFFFUL},
	{0x00F8U, 0x0000000000000000UL},
	{0x0100U, 0x0000000000000000UL},
	{0x0108U, 0x0000000000000000UL},
	{0x0110U, 0x001010080000FFFFUL},
	{0x0118U, 0x0000000000000000UL},
	{0x0120U, 0x0000000000000000UL},
	{0x0128U, 0x0000000000000000UL},
	{0x0130U, 0x0000000000000000UL},
	{0x0138U, 0x00100C0A0000FFFFUL},
	{0x0140U, 0x0000000000000000UL},
	{0x0148U, 0x0000000000000000UL},
	{0x0150U, 0x00100C0A0000FFFFUL},
	{0x0158U, 0x0000000000000000UL},
	{0x0160U, 0x00100C0A0000FFFFUL},
	{0x0168U, 0x0000000000000000UL},
	{0x0170U, 0x0000000000000000UL},
	{0x0178U, 0x001008050000FFFFUL},
	{0x0180U, 0x0000000000000000UL},
	{0x0188U, 0x0000000000000000UL},
	{0x0190U, 0x001028280000FFFFUL},
	{0x0198U, 0x0000000000000000UL},
	{0x01A0U, 0x00100C0A0000FFFFUL},
	{0x01A8U, 0x0000000000000000UL},
	{0x01B0U, 0x0000000000000000UL},
	{0x01B8U, 0x0000000000000000UL},
	{0x01C0U, 0x0000000000000000UL},
	{0x01C8U, 0x0000000000000000UL},
	{0x01D0U, 0x0000000000000000UL},
	{0x01D8U, 0x0000000000000000UL},
	{0x01E0U, 0x0000000000000000UL},
	{0x01E8U, 0x0000000000000000UL},
	{0x01F0U, 0x0000000000000000UL},
	{0x01F8U, 0x0000000000000000UL},
	{0x0200U, 0x0000000000000000UL},
	{0x0208U, 0x0000000000000000UL},
	{0x0210U, 0x0000000000000000UL},
	{0x0218U, 0x0000000000000000UL},
	{0x0220U, 0x0000000000000000UL},
	{0x0228U, 0x0000000000000000UL},
	{0x0230U, 0x0000000000000000UL},
	{0x0238U, 0x0000000000000000UL},
	{0x0240U, 0x0000000000000000UL},
	{0x0248U, 0x0000000000000000UL},
	{0x0250U, 0x0000000000000000UL},
	{0x0258U, 0x0000000000000000UL},
	{0x0260U, 0x0000000000000000UL},
	{0x0268U, 0x001408010000FFFFUL},
	{0x0270U, 0x001404010000FFFFUL},
	{0x0278U, 0x0000000000000000UL},
	{0x0280U, 0x0000000000000000UL},
	{0x0288U, 0x0000000000000000UL},
	{0x0290U, 0x001408010000FFFFUL},
	{0x0298U, 0x001404010000FFFFUL},
	{0x02A0U, 0x000C04010000FFFFUL},
	{0x02A8U, 0x000C04010000FFFFUL},
	{0x02B0U, 0x001404010000FFFFUL},
	{0x02B8U, 0x0000000000000000UL},
	{0x02C0U, 0x0000000000000000UL},
	{0x02C8U, 0x0000000000000000UL},
	{0x02D0U, 0x000C04010000FFFFUL},
	{0x02D8U, 0x000C04010000FFFFUL},
	{0x02E0U, 0x001404010000FFFFUL},
	{0x02E8U, 0x0000000000000000UL},
	{0x02F0U, 0x0000000000000000UL},
	{0x02F8U, 0x0000000000000000UL},
	{0x0300U, 0x0000000000000000UL},
	{0x0308U, 0x0000000000000000UL},
	{0x0310U, 0x0000000000000000UL},
	{0x0318U, 0x0000000000000000UL},
	{0x0320U, 0x0000000000000000UL},
	{0x0328U, 0x0000000000000000UL},
	{0x0330U, 0x0000000000000000UL},
	{0x0338U, 0x0000000000000000UL},
	{0x0340U, 0x0000000000000000UL},
	{0x0348U, 0x0000000000000000UL},
	{0x0350U, 0x0000000000000000UL},
};

static const mstat_slot_t mstat_be[] = {
	{0x0000U, 0x001200100C89C401UL},
	{0x0008U, 0x001200100C89C401UL},
	{0x0010U, 0x001200100C89C401UL},
	{0x0018U, 0x001200100C89C401UL},
	{0x0020U, 0x0000000000000000UL},
	{0x0028U, 0x001100100C803401UL},
	{0x0030U, 0x0000000000000000UL},
	{0x0038U, 0x0000000000000000UL},
	{0x0040U, 0x0000000000000000UL},
	{0x0048U, 0x0000000000000000UL},
	{0x0050U, 0x0000000000000000UL},
	{0x0058U, 0x0000000000000000UL},
	{0x0060U, 0x0000000000000000UL},
	{0x0068U, 0x0000000000000000UL},
	{0x0070U, 0x0000000000000000UL},
	{0x0078U, 0x0000000000000000UL},
	{0x0080U, 0x0000000000000000UL},
	{0x0088U, 0x0000000000000000UL},
	{0x0090U, 0x0000000000000000UL},
	{0x0098U, 0x0000000000000000UL},
	{0x00A0U, 0x0000000000000000UL},
	{0x00A8U, 0x0000000000000000UL},
	{0x00B0U, 0x0000000000000000UL},
	{0x00B8U, 0x0000000000000000UL},
	{0x00C0U, 0x0000000000000000UL},
	{0x00C8U, 0x0000000000000000UL},
	{0x00D0U, 0x0000000000000000UL},
	{0x00D8U, 0x0000000000000000UL},
	{0x00E0U, 0x0000000000000000UL},
	{0x00E8U, 0x0000000000000000UL},
	{0x00F0U, 0x0000000000000000UL},
	{0x00F8U, 0x0000000000000000UL},
	{0x0100U, 0x0000000000000000UL},
	{0x0108U, 0x0000000000000000UL},
	{0x0110U, 0x0000000000000000UL},
	{0x0118U, 0x0000000000000000UL},
	{0x0120U, 0x0000000000000000UL},
	{0x0128U, 0x0000000000000000UL},
	{0x0130U, 0x0000000000000000UL},
	{0x0138U, 0x0000000000000000UL},
	{0x0140U, 0x0000000000000000UL},
	{0x0148U, 0x0000000000000000UL},
	{0x0150U, 0x0000000000000000UL},
	{0x0158U, 0x0000000000000000UL},
	{0x0160U, 0x0000000000000000UL},
	{0x0168U, 0x0000000000000000UL},
	{0x0170U, 0x0000000000000000UL},
	{0x0178U, 0x0000000000000000UL},
	{0x0180U, 0x0000000000000000UL},
	{0x0188U, 0x0000000000000000UL},
	{0x0190U, 0x0000000000000000UL},
	{0x0198U, 0x0000000000000000UL},
	{0x01A0U, 0x0000000000000000UL},
	{0x01A8U, 0x0000000000000000UL},
	{0x01B0U, 0x0000000000000000UL},
	{0x01B8U, 0x0000000000000000UL},
	{0x01C0U, 0x001100500C8FFC01UL},
	{0x01C8U, 0x001100500C8FFC01UL},
	{0x01D0U, 0x001100500C8FFC01UL},
	{0x01D8U, 0x001100500C8FFC01UL},
	{0x01E0U, 0x0000000000000000UL},
	{0x01E8U, 0x001200100C803401UL},
	{0x01F0U, 0x001100100C80FC01UL},
	{0x01F8U, 0x0000000000000000UL},
	{0x0200U, 0x0000000000000000UL},
	{0x0208U, 0x001200100C80FC01UL},
	{0x0210U, 0x001100100C80FC01UL},
	{0x0218U, 0x001100100C825801UL},
	{0x0220U, 0x001100100C825801UL},
	{0x0228U, 0x0000000000000000UL},
	{0x0230U, 0x001100100C825801UL},
	{0x0238U, 0x001100100C825801UL},
	{0x0240U, 0x001200100C8BB801UL},
	{0x0248U, 0x001100100C8EA401UL},
	{0x0250U, 0x001200100C8BB801UL},
	{0x0258U, 0x001100100C8EA401UL},
	{0x0260U, 0x001100100C84E401UL},
	{0x0268U, 0x0000000000000000UL},
	{0x0270U, 0x0000000000000000UL},
	{0x0278U, 0x001100100C81F401UL},
	{0x0280U, 0x0000000000000000UL},
	{0x0288U, 0x0000000000000000UL},
	{0x0290U, 0x0000000000000000UL},
	{0x0298U, 0x0000000000000000UL},
	{0x02A0U, 0x0000000000000000UL},
	{0x02A8U, 0x0000000000000000UL},
	{0x02B0U, 0x0000000000000000UL},
	{0x02B8U, 0x001100100C803401UL},
	{0x02C0U, 0x0000000000000000UL},
	{0x02C8U, 0x0000000000000000UL},
	{0x02D0U, 0x0000000000000000UL},
	{0x02D8U, 0x0000000000000000UL},
	{0x02E0U, 0x0000000000000000UL},
	{0x02E8U, 0x001100100C803401UL},
	{0x02F0U, 0x001100300C8FFC01UL},
	{0x02F8U, 0x001100500C8FFC01UL},
	{0x0300U, 0x0000000000000000UL},
	{0x0308U, 0x001100300C8FFC01UL},
	{0x0310U, 0x001100500C8FFC01UL},
	{0x0318U, 0x001200100C803401UL},
	{0x0320U, 0x0000000000000000UL},
	{0x0328U, 0x0000000000000000UL},
	{0x0330U, 0x0000000000000000UL},
	{0x0338U, 0x0000000000000000UL},
	{0x0340U, 0x0000000000000000UL},
	{0x0348U, 0x0000000000000000UL},
	{0x0350U, 0x0000000000000000UL},
};
#endif

static void dbsc_setting(void)
{
	uint32_t md = 0;

	/* BUFCAM settings */
	/* DBSC_DBCAM0CNF0 not set */
	io_write_32(DBSC_DBCAM0CNF1, 0x00043218);	/* dbcam0cnf1 */
	io_write_32(DBSC_DBCAM0CNF2, 0x000000F4);	/* dbcam0cnf2 */
	io_write_32(DBSC_DBCAM0CNF3, 0x00000000);	/* dbcam0cnf3 */
	io_write_32(DBSC_DBSCHCNT0, 0x080F0037);	/* dbschcnt0 */
	/* DBSC_DBSCHCNT1 not set */
	io_write_32(DBSC_DBSCHSZ0, 0x00000001);	/* dbschsz0 */
	io_write_32(DBSC_DBSCHRW0, 0x22421111);	/* dbschrw0 */

	md = (*((volatile uint32_t *)RST_MODEMR) & 0x000A0000) >> 17;

	switch (md) {
	case 0x0:
		/* DDR3200 */
		io_write_32(DBSC_SCFCTST2, 0x012F1123);
		break;
	case 0x1:		/* MD19=0,MD17=1 : LPDDR4-3000, 4GByte(1GByte x4) */
		/* DDR2800 */
		io_write_32(DBSC_SCFCTST2, 0x012F1123);
		break;
	case 0x4:		/* MD19=1,MD17=0 : LPDDR4-2400, 4GByte(1GByte x4) */
		/* DDR2400 */
		io_write_32(DBSC_SCFCTST2, 0x012F1123);
		break;
	default:		/* MD19=1,MD17=1 : LPDDR4-1600, 4GByte(1GByte x4) */
		/* DDR1600 */
		io_write_32(DBSC_SCFCTST2, 0x012F1123);
		break;
	}

	/* QoS Settings */
	io_write_32(DBSC_DBSCHQOS00, 0x00000F00);
	io_write_32(DBSC_DBSCHQOS01, 0x00000B00);
	io_write_32(DBSC_DBSCHQOS02, 0x00000000);
	io_write_32(DBSC_DBSCHQOS03, 0x00000000);
	/* DBSC_DBSCHQOS10 not set */
	/* DBSC_DBSCHQOS11 not set */
	/* DBSC_DBSCHQOS12 not set */
	/* DBSC_DBSCHQOS13 not set */
	/* DBSC_DBSCHQOS20 not set */
	/* DBSC_DBSCHQOS21 not set */
	/* DBSC_DBSCHQOS22 not set */
	/* DBSC_DBSCHQOS23 not set */
	/* DBSC_DBSCHQOS30 not set */
	/* DBSC_DBSCHQOS31 not set */
	/* DBSC_DBSCHQOS32 not set */
	/* DBSC_DBSCHQOS33 not set */
	io_write_32(DBSC_DBSCHQOS40, 0x00000300);
	io_write_32(DBSC_DBSCHQOS41, 0x000002F0);
	io_write_32(DBSC_DBSCHQOS42, 0x00000200);
	io_write_32(DBSC_DBSCHQOS43, 0x00000100);
	/* DBSC_DBSCHQOS50 not set */
	/* DBSC_DBSCHQOS51 not set */
	/* DBSC_DBSCHQOS52 not set */
	/* DBSC_DBSCHQOS53 not set */
	/* DBSC_DBSCHQOS60 not set */
	/* DBSC_DBSCHQOS61 not set */
	/* DBSC_DBSCHQOS62 not set */
	/* DBSC_DBSCHQOS63 not set */
	/* DBSC_DBSCHQOS70 not set */
	/* DBSC_DBSCHQOS71 not set */
	/* DBSC_DBSCHQOS72 not set */
	/* DBSC_DBSCHQOS73 not set */
	/* DBSC_DBSCHQOS80 not set */
	/* DBSC_DBSCHQOS81 not set */
	/* DBSC_DBSCHQOS82 not set */
	/* DBSC_DBSCHQOS83 not set */
	io_write_32(DBSC_DBSCHQOS90, 0x00000300);
	io_write_32(DBSC_DBSCHQOS91, 0x000002F0);
	io_write_32(DBSC_DBSCHQOS92, 0x00000200);
	io_write_32(DBSC_DBSCHQOS93, 0x00000100);
	/* DBSC_DBSCHQOS100 not set */
	/* DBSC_DBSCHQOS101 not set */
	/* DBSC_DBSCHQOS102 not set */
	/* DBSC_DBSCHQOS103 not set */
	/* DBSC_DBSCHQOS110 not set */
	/* DBSC_DBSCHQOS111 not set */
	/* DBSC_DBSCHQOS112 not set */
	/* DBSC_DBSCHQOS113 not set */
	/* DBSC_DBSCHQOS120 not set */
	/* DBSC_DBSCHQOS121 not set */
	/* DBSC_DBSCHQOS122 not set */
	/* DBSC_DBSCHQOS123 not set */
	io_write_32(DBSC_DBSCHQOS130, 0x00000100);
	io_write_32(DBSC_DBSCHQOS131, 0x000000F0);
	io_write_32(DBSC_DBSCHQOS132, 0x000000A0);
	io_write_32(DBSC_DBSCHQOS133, 0x00000040);
	io_write_32(DBSC_DBSCHQOS140, 0x000000C0);
	io_write_32(DBSC_DBSCHQOS141, 0x000000B0);
	io_write_32(DBSC_DBSCHQOS142, 0x00000080);
	io_write_32(DBSC_DBSCHQOS143, 0x00000040);
	io_write_32(DBSC_DBSCHQOS150, 0x00000040);
	io_write_32(DBSC_DBSCHQOS151, 0x00000030);
	io_write_32(DBSC_DBSCHQOS152, 0x00000020);
	io_write_32(DBSC_DBSCHQOS153, 0x00000010);
}

void qos_init_m3_v10(void)
{
	dbsc_setting();

	/* DRAM Split Address mapping */
#if RCAR_DRAM_SPLIT == RCAR_DRAM_SPLIT_4CH
#if RCAR_LSI == RCAR_M3
#error "Don't set DRAM Split 4ch(M3)"
#else
	ERROR("DRAM Split 4ch not supported.(M3)");
	panic();
#endif
#elif (RCAR_DRAM_SPLIT == RCAR_DRAM_SPLIT_2CH) || \
      (RCAR_DRAM_SPLIT == RCAR_DRAM_SPLIT_AUTO)
	NOTICE("BL2: DRAM Split is 2ch\n");
	io_write_32(AXI_ADSPLCR0, 0x00000000U);
	io_write_32(AXI_ADSPLCR1, ADSPLCR0_ADRMODE_DEFAULT
		    | ADSPLCR0_SPLITSEL(0xFFU)
		    | ADSPLCR0_AREA(0x1CU)
		    | ADSPLCR0_SWP);
	io_write_32(AXI_ADSPLCR2, 0x089A0000U);
	io_write_32(AXI_ADSPLCR3, 0x00000000U);
#else
	NOTICE("BL2: DRAM Split is OFF\n");
#endif

#if !(RCAR_QOS_TYPE == RCAR_QOS_NONE)
#if RCAR_QOS_TYPE  == RCAR_QOS_TYPE_DEFAULT
	NOTICE("BL2: QoS is default setting(%s)\n", RCAR_QOS_VERSION);
#endif

	/* Resource Alloc setting */
	io_write_32(QOSCTRL_RAS, 0x00000028U);
	io_write_32(QOSCTRL_FIXTH, 0x000F0005U);
	io_write_32(QOSCTRL_REGGD, 0x00000000U);
	io_write_64(QOSCTRL_DANN, 0x0101010102020201UL);
	io_write_32(QOSCTRL_DANT, 0x00100804U);
	io_write_32(QOSCTRL_EC, 0x00000000U);
	io_write_64(QOSCTRL_EMS, 0x0000000000000000UL);
	io_write_32(QOSCTRL_FSS, 0x000003e8U);
	io_write_32(QOSCTRL_INSFC, 0xC7840001U);
	io_write_32(QOSCTRL_BERR, 0x00000000U);
	io_write_32(QOSCTRL_RACNT0, 0x00000000U);

	/* QOSBW setting */
	io_write_32(QOSCTRL_SL_INIT,
		    SL_INIT_REFFSSLOT | SL_INIT_SLOTSSLOT | SL_INIT_SSLOTCLK);
	io_write_32(QOSCTRL_REF_ARS, 0x00330000U);

	/* QOSBW SRAM setting */
	{
		uint32_t i;

		for (i = 0U; i < ARRAY_SIZE(mstat_fix); i++) {
			io_write_64(QOSBW_FIX_QOS_BANK0 + mstat_fix[i].addr,
				    mstat_fix[i].value);
			io_write_64(QOSBW_FIX_QOS_BANK1 + mstat_fix[i].addr,
				    mstat_fix[i].value);
		}
		for (i = 0U; i < ARRAY_SIZE(mstat_be); i++) {
			io_write_64(QOSBW_BE_QOS_BANK0 + mstat_be[i].addr,
				    mstat_be[i].value);
			io_write_64(QOSBW_BE_QOS_BANK1 + mstat_be[i].addr,
				    mstat_be[i].value);
		}
	}

	/* 3DG bus Leaf setting */
	io_write_32(0xFD820808U, 0x00001234U);
	io_write_32(0xFD820800U, 0x00000006U);
	io_write_32(0xFD821800U, 0x00000006U);
	io_write_32(0xFD822800U, 0x00000006U);
	io_write_32(0xFD823800U, 0x00000006U);
	io_write_32(0xFD824800U, 0x00000006U);
	io_write_32(0xFD825800U, 0x00000006U);
	io_write_32(0xFD826800U, 0x00000006U);
	io_write_32(0xFD827800U, 0x00000006U);

	/* RT bus Leaf setting */
	io_write_32(0xFFC50800U, 0x00000000U);
	io_write_32(0xFFC51800U, 0x00000000U);

	/* Resource Alloc start */
	io_write_32(QOSCTRL_RAEN, 0x00000001U);

	/* QOSBW start */
	io_write_32(QOSCTRL_STATQC, 0x00000001U);
#else
	NOTICE("BL2: QoS is None\n");

	/* Resource Alloc setting */
	io_write_32(QOSCTRL_EC, 0x00000000U);
	/* Resource Alloc start */
	io_write_32(QOSCTRL_RAEN, 0x00000001U);
#endif /* !(RCAR_QOS_TYPE == RCAR_QOS_NONE) */
}
