/*
 * Copyright (c) 2014-2015, ARM Limited and Contributors. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of ARM nor the names of its contributors may be used
 * to endorse or promote products derived from this software without specific
 * prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef __ARM_CONFIG_H__
#define __ARM_CONFIG_H__

#include <stdint.h>

enum arm_config_flags {
	/* Whether Base memory map is in use */
	ARM_CONFIG_BASE_MMAP		= 0x1,
	/* Whether CCI should be enabled */
	ARM_CONFIG_HAS_CCI		= 0x2,
	/* Whether TZC should be configured */
	ARM_CONFIG_HAS_TZC		= 0x4
};

typedef struct arm_config {
	uintptr_t gicd_base;
	uintptr_t gicc_base;
	uintptr_t gich_base;
	uintptr_t gicv_base;
	unsigned int max_aff0;
	unsigned int max_aff1;
	unsigned long flags;
} arm_config_t;


/* If used, arm_config must be defined and populated in the platform port */
extern arm_config_t arm_config;

static inline const arm_config_t *get_arm_config(void)
{
	return &arm_config;
}


#endif /* __ARM_CONFIG_H__ */
