/*
 * Copyright (c) 2019-2020, NVIDIA Corporation. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef TEGRA_MC_DEF_H
#define TEGRA_MC_DEF_H

/*******************************************************************************
 * Memory Controller Order_id registers
 ******************************************************************************/
#define MC_CLIENT_ORDER_ID_9				U(0x2a24)
#define  MC_CLIENT_ORDER_ID_9_RESET_VAL			0x00000000U
#define  MC_CLIENT_ORDER_ID_9_XUSB_HOSTW_MASK		(0x3U << 12)
#define  MC_CLIENT_ORDER_ID_9_XUSB_HOSTW_ORDER_ID	(3U << 12)

#define MC_CLIENT_ORDER_ID_27				U(0x2a6c)
#define  MC_CLIENT_ORDER_ID_27_RESET_VAL		0x00000000U
#define  MC_CLIENT_ORDER_ID_27_PCIE0W_MASK		(0x3U << 4)
#define  MC_CLIENT_ORDER_ID_27_PCIE0W_ORDER_ID		(1U << 4)

#define MC_CLIENT_ORDER_ID_28				U(0x2a70)
#define  MC_CLIENT_ORDER_ID_28_RESET_VAL		0x00000000U
#define  MC_CLIENT_ORDER_ID_28_PCIE4W_MASK		(0x3U << 4)
#define  MC_CLIENT_ORDER_ID_28_PCIE4W_ORDER_ID		(3U << 4)
#define  MC_CLIENT_ORDER_ID_28_PCIE5W_MASK		(0x3U << 12)
#define  MC_CLIENT_ORDER_ID_28_PCIE5W_ORDER_ID		(2U << 12)

#define mc_client_order_id(val, id, client) \
	((val & ~MC_CLIENT_ORDER_ID_##id##_##client##_MASK) | \
	MC_CLIENT_ORDER_ID_##id##_##client##_ORDER_ID)

/*******************************************************************************
 * Memory Controller's VC ID configuration registers
 ******************************************************************************/
#define VC_NISO						0U
#define VC_SISO						1U
#define VC_ISO						2U

#define MC_HUB_PC_VC_ID_0				U(0x2a78)
#define  MC_HUB_PC_VC_ID_0_RESET_VAL 			0x00020100U
#define  MC_HUB_PC_VC_ID_0_APB_VC_ID_MASK		(0x3U << 8)
#define  MC_HUB_PC_VC_ID_0_APB_VC_ID			(VC_NISO << 8)

#define MC_HUB_PC_VC_ID_2				U(0x2a80)
#define  MC_HUB_PC_VC_ID_2_RESET_VAL 			0x10001000U
#define  MC_HUB_PC_VC_ID_2_SD_VC_ID_MASK		(0x3U << 28)
#define  MC_HUB_PC_VC_ID_2_SD_VC_ID			(VC_NISO << 28)

#define MC_HUB_PC_VC_ID_4				U(0x2a88)
#define  MC_HUB_PC_VC_ID_4_RESET_VAL 			0x10020011U
#define  MC_HUB_PC_VC_ID_4_NIC_VC_ID_MASK		(0x3U << 28)
#define  MC_HUB_PC_VC_ID_4_NIC_VC_ID			(VC_NISO << 28)

#define mc_hub_vc_id(val, id, client) \
	((val & ~MC_HUB_PC_VC_ID_##id##_##client##_VC_ID_MASK) | \
	MC_HUB_PC_VC_ID_##id##_##client##_VC_ID)

/*******************************************************************************
 * Memory Controller's PCFIFO client configuration registers
 ******************************************************************************/
#define MC_PCFIFO_CLIENT_CONFIG0				0xdd0U

#define MC_PCFIFO_CLIENT_CONFIG1				0xdd4U
#define  MC_PCFIFO_CLIENT_CONFIG1_RESET_VAL			0x20200000U
#define  MC_PCFIFO_CLIENT_CONFIG1_PCFIFO_AFIW_UNORDERED		(0U << 17)
#define  MC_PCFIFO_CLIENT_CONFIG1_PCFIFO_AFIW_MASK		(1U << 17)
#define  MC_PCFIFO_CLIENT_CONFIG1_PCFIFO_HDAW_UNORDERED		(0U << 21)
#define  MC_PCFIFO_CLIENT_CONFIG1_PCFIFO_HDAW_MASK		(1U << 21)
#define  MC_PCFIFO_CLIENT_CONFIG1_PCFIFO_SATAW_UNORDERED	(0U << 29)
#define  MC_PCFIFO_CLIENT_CONFIG1_PCFIFO_SATAW_ORDERED		(1U << 29)
#define  MC_PCFIFO_CLIENT_CONFIG1_PCFIFO_SATAW_MASK		(1U << 29)

#define MC_PCFIFO_CLIENT_CONFIG2				0xdd8U
#define  MC_PCFIFO_CLIENT_CONFIG2_RESET_VAL			0x00002800U
#define  MC_PCFIFO_CLIENT_CONFIG2_PCFIFO_XUSB_HOSTW_UNORDERED	(0U << 11)
#define  MC_PCFIFO_CLIENT_CONFIG2_PCFIFO_XUSB_HOSTW_MASK	(1U << 11)
#define  MC_PCFIFO_CLIENT_CONFIG2_PCFIFO_XUSB_DEVW_UNORDERED	(0U << 13)
#define  MC_PCFIFO_CLIENT_CONFIG2_PCFIFO_XUSB_DEVW_ORDERED	(1U << 13)
#define  MC_PCFIFO_CLIENT_CONFIG2_PCFIFO_XUSB_DEVW_MASK		(1U << 13)
#define  MC_PCFIFO_CLIENT_CONFIG2_PCFIFO_TSECSWR_UNORDERED	(0U << 21)
#define  MC_PCFIFO_CLIENT_CONFIG2_PCFIFO_TSECSWR_MASK		(1U << 21)

#define MC_PCFIFO_CLIENT_CONFIG3				0xddcU
#define  MC_PCFIFO_CLIENT_CONFIG3_RESET_VAL			0x08000080U
#define  MC_PCFIFO_CLIENT_CONFIG3_PCFIFO_SDMMCWA_UNORDERED	(0U << 4)
#define  MC_PCFIFO_CLIENT_CONFIG3_PCFIFO_SDMMCWA_MASK		(1U << 4)
#define  MC_PCFIFO_CLIENT_CONFIG3_PCFIFO_SDMMCW_UNORDERED	(0U << 6)
#define  MC_PCFIFO_CLIENT_CONFIG3_PCFIFO_SDMMCW_MASK		(1U << 6)
#define  MC_PCFIFO_CLIENT_CONFIG3_PCFIFO_SDMMCWAB_UNORDERED	(0U << 7)
#define  MC_PCFIFO_CLIENT_CONFIG3_PCFIFO_SDMMCWAB_MASK		(1U << 7)
#define  MC_PCFIFO_CLIENT_CONFIG3_PCFIFO_VICSWR_UNORDERED	(0U << 13)
#define  MC_PCFIFO_CLIENT_CONFIG3_PCFIFO_VICSWR_MASK		(1U << 13)
#define  MC_PCFIFO_CLIENT_CONFIG3_PCFIFO_APEW_UNORDERED		(0U << 27)
#define  MC_PCFIFO_CLIENT_CONFIG3_PCFIFO_APEW_MASK		(1U << 27)

#define MC_PCFIFO_CLIENT_CONFIG4				0xde0U
#define  MC_PCFIFO_CLIENT_CONFIG4_RESET_VAL			0x5552a022U
#define  MC_PCFIFO_CLIENT_CONFIG4_PCFIFO_SESWR_UNORDERED 	(0U << 1)
#define  MC_PCFIFO_CLIENT_CONFIG4_PCFIFO_SESWR_MASK		(1U << 1)
#define  MC_PCFIFO_CLIENT_CONFIG4_PCFIFO_ETRW_UNORDERED		(0U << 5)
#define  MC_PCFIFO_CLIENT_CONFIG4_PCFIFO_ETRW_MASK		(1U << 5)
#define  MC_PCFIFO_CLIENT_CONFIG4_PCFIFO_TSECSWRB_UNORDERED	(0U << 7)
#define  MC_PCFIFO_CLIENT_CONFIG4_PCFIFO_TSECSWRB_MASK		(1U << 7)
#define  MC_PCFIFO_CLIENT_CONFIG4_PCFIFO_AXISW_UNORDERED 	(0U << 13)
#define  MC_PCFIFO_CLIENT_CONFIG4_PCFIFO_AXISW_MASK		(1U << 13)
#define  MC_PCFIFO_CLIENT_CONFIG4_PCFIFO_EQOSW_ORDERED 		(1U << 15)
#define  MC_PCFIFO_CLIENT_CONFIG4_PCFIFO_EQOSW_MASK		(1U << 15)
#define  MC_PCFIFO_CLIENT_CONFIG4_PCFIFO_UFSHCW_UNORDERED	(0U << 17)
#define  MC_PCFIFO_CLIENT_CONFIG4_PCFIFO_UFSHCW_MASK		(1U << 17)
#define  MC_PCFIFO_CLIENT_CONFIG4_PCFIFO_BPMPW_UNORDERED	(0U << 20)
#define  MC_PCFIFO_CLIENT_CONFIG4_PCFIFO_BPMPW_MASK		(1U << 20)
#define  MC_PCFIFO_CLIENT_CONFIG4_PCFIFO_BPMPDMAW_UNORDERED	(0U << 22)
#define  MC_PCFIFO_CLIENT_CONFIG4_PCFIFO_BPMPDMAW_MASK		(1U << 22)
#define  MC_PCFIFO_CLIENT_CONFIG4_PCFIFO_AONW_UNORDERED		(0U << 24)
#define  MC_PCFIFO_CLIENT_CONFIG4_PCFIFO_AONW_MASK		(1U << 24)
#define  MC_PCFIFO_CLIENT_CONFIG4_PCFIFO_AONDMAW_UNORDERED	(0U << 26)
#define  MC_PCFIFO_CLIENT_CONFIG4_PCFIFO_AONDMAW_MASK		(1U << 26)
#define  MC_PCFIFO_CLIENT_CONFIG4_PCFIFO_SCEW_UNORDERED		(0U << 28)
#define  MC_PCFIFO_CLIENT_CONFIG4_PCFIFO_SCEW_MASK		(1U << 28)
#define  MC_PCFIFO_CLIENT_CONFIG4_PCFIFO_SCEDMAW_UNORDERED	(0U << 30)
#define  MC_PCFIFO_CLIENT_CONFIG4_PCFIFO_SCEDMAW_MASK		(1U << 30)

#define MC_PCFIFO_CLIENT_CONFIG5				0xbf4U
#define  MC_PCFIFO_CLIENT_CONFIG5_RESET_VAL			0x20000001U
#define  MC_PCFIFO_CLIENT_CONFIG5_PCFIFO_APEDMAW_UNORDERED	(0U << 0)
#define  MC_PCFIFO_CLIENT_CONFIG5_PCFIFO_APEDMAW_MASK		(1U << 0)
#define  MC_PCFIFO_CLIENT_CONFIG5_PCFIFO_VIFALW_UNORDERED	(0U << 30)
#define  MC_PCFIFO_CLIENT_CONFIG5_PCFIFO_VIFALW_MASK		(1U << 30)

#define MC_PCFIFO_CLIENT_CONFIG6				0xb90U
#define  MC_PCFIFO_CLIENT_CONFIG6_RESET_VAL			0xaa280000U
#define  MC_PCFIFO_CLIENT_CONFIG6_PCFIFO_RCEW_UNORDERED		(0U << 19)
#define  MC_PCFIFO_CLIENT_CONFIG6_PCFIFO_RCEW_MASK		(1U << 19)
#define  MC_PCFIFO_CLIENT_CONFIG6_PCFIFO_RCEDMAW_UNORDERED	(0U << 21)
#define  MC_PCFIFO_CLIENT_CONFIG6_PCFIFO_RCEDMAW_MASK		(1U << 21)
#define  MC_PCFIFO_CLIENT_CONFIG6_PCFIFO_PCIE0W_UNORDERED	(0U << 25)
#define  MC_PCFIFO_CLIENT_CONFIG6_PCFIFO_PCIE0W_MASK		(1U << 25)
#define  MC_PCFIFO_CLIENT_CONFIG6_PCFIFO_PCIE1W_ORDERED		(1U << 27)
#define  MC_PCFIFO_CLIENT_CONFIG6_PCFIFO_PCIE1W_MASK		(1U << 27)
#define  MC_PCFIFO_CLIENT_CONFIG6_PCFIFO_PCIE2W_ORDERED		(1U << 29)
#define  MC_PCFIFO_CLIENT_CONFIG6_PCFIFO_PCIE2W_MASK		(1U << 29)
#define  MC_PCFIFO_CLIENT_CONFIG6_PCFIFO_PCIE3W_ORDERED		(1U << 31)
#define  MC_PCFIFO_CLIENT_CONFIG6_PCFIFO_PCIE3W_MASK		(1U << 31)

#define MC_PCFIFO_CLIENT_CONFIG7				0xaccU
#define  MC_PCFIFO_CLIENT_CONFIG7_RESET_VAL			0x0000000aU
#define  MC_PCFIFO_CLIENT_CONFIG7_PCFIFO_PCIE4W_UNORDERED	(0U << 1)
#define  MC_PCFIFO_CLIENT_CONFIG7_PCFIFO_PCIE4W_MASK		(1U << 1)
#define  MC_PCFIFO_CLIENT_CONFIG7_PCFIFO_PCIE5W_UNORDERED	(0U << 3)
#define  MC_PCFIFO_CLIENT_CONFIG7_PCFIFO_PCIE5W_MASK		(1U << 3)

/*******************************************************************************
 * StreamID to indicate no SMMU translations (requests to be steered on the
 * SMMU bypass path)
 ******************************************************************************/
#define MC_STREAM_ID_MAX					0x7FU

/*******************************************************************************
 * Stream ID Override Config registers
 ******************************************************************************/
#define MC_STREAMID_OVERRIDE_CFG_PVA1RDA			0x660U
#define MC_STREAMID_OVERRIDE_CFG_NVENCSRD			0xe0U
#define MC_STREAMID_OVERRIDE_CFG_NVJPGSWR			0x3f8U
#define MC_STREAMID_OVERRIDE_CFG_PVA0RDA1			0x758U
#define MC_STREAMID_OVERRIDE_CFG_PVA0RDC			0x640U
#define MC_STREAMID_OVERRIDE_CFG_DLA0RDA			0x5f0U
#define MC_STREAMID_OVERRIDE_CFG_BPMPR				0x498U
#define MC_STREAMID_OVERRIDE_CFG_APEDMAR			0x4f8U
#define MC_STREAMID_OVERRIDE_CFG_AXISR				0x460U
#define MC_STREAMID_OVERRIDE_CFG_TSECSRD			0x2a0U
#define MC_STREAMID_OVERRIDE_CFG_DLA0FALRDB			0x5f8U
#define MC_STREAMID_OVERRIDE_CFG_NVENC1SRD1			0x788U
#define MC_STREAMID_OVERRIDE_CFG_MPCOREW			0x1c8U
#define MC_STREAMID_OVERRIDE_CFG_NVENCSRD1			0x780U
#define MC_STREAMID_OVERRIDE_CFG_XUSB_HOSTR			0x250U
#define MC_STREAMID_OVERRIDE_CFG_MIU1R				0x540U
#define MC_STREAMID_OVERRIDE_CFG_MIU0R				0x530U
#define MC_STREAMID_OVERRIDE_CFG_PCIE1W				0x6d8U
#define MC_STREAMID_OVERRIDE_CFG_PVA1WRA			0x678U
#define MC_STREAMID_OVERRIDE_CFG_XUSB_HOSTW			0x258U
#define MC_STREAMID_OVERRIDE_CFG_AXIAPW				0x418U
#define MC_STREAMID_OVERRIDE_CFG_SDMMCWAB			0x338U
#define MC_STREAMID_OVERRIDE_CFG_SATAW				0x1e8U
#define MC_STREAMID_OVERRIDE_CFG_DLA0WRA			0x600U
#define MC_STREAMID_OVERRIDE_CFG_PCIE3R				0x6f0U
#define MC_STREAMID_OVERRIDE_CFG_MIU3W				0x588U
#define MC_STREAMID_OVERRIDE_CFG_SCEDMAR			0x4e8U
#define MC_STREAMID_OVERRIDE_CFG_HOST1XDMAR			0xb0U
#define MC_STREAMID_OVERRIDE_CFG_SDMMCWA			0x320U
#define MC_STREAMID_OVERRIDE_CFG_MIU2R				0x570U
#define MC_STREAMID_OVERRIDE_CFG_APEDMAW			0x500U
#define MC_STREAMID_OVERRIDE_CFG_PCIE2AW			0x6e8U
#define MC_STREAMID_OVERRIDE_CFG_SESWR				0x408U
#define MC_STREAMID_OVERRIDE_CFG_PVA1RDB1			0x770U
#define MC_STREAMID_OVERRIDE_CFG_AXISW				0x468U
#define MC_STREAMID_OVERRIDE_CFG_DLA1FALRDB			0x618U
#define MC_STREAMID_OVERRIDE_CFG_AONDMAW			0x4d0U
#define MC_STREAMID_OVERRIDE_CFG_TSECSWRB			0x438U
#define MC_STREAMID_OVERRIDE_CFG_ISPWB				0x238U
#define MC_STREAMID_OVERRIDE_CFG_HDAR				0xa8U
#define MC_STREAMID_OVERRIDE_CFG_SDMMCRA			0x300U
#define MC_STREAMID_OVERRIDE_CFG_ETRW				0x428U
#define MC_STREAMID_OVERRIDE_CFG_RCEDMAW			0x6a8U
#define MC_STREAMID_OVERRIDE_CFG_TSECSWR			0x2a8U
#define MC_STREAMID_OVERRIDE_CFG_ETRR				0x420U
#define MC_STREAMID_OVERRIDE_CFG_SDMMCR				0x310U
#define MC_STREAMID_OVERRIDE_CFG_NVJPGSRD			0x3f0U
#define MC_STREAMID_OVERRIDE_CFG_AONDMAR			0x4c8U
#define MC_STREAMID_OVERRIDE_CFG_SCER				0x4d8U
#define MC_STREAMID_OVERRIDE_CFG_MIU5W				0x7e8U
#define MC_STREAMID_OVERRIDE_CFG_NVENC1SRD			0x6b0U
#define MC_STREAMID_OVERRIDE_CFG_PCIE4R				0x700U
#define MC_STREAMID_OVERRIDE_CFG_ISPWA				0x230U
#define MC_STREAMID_OVERRIDE_CFG_PCIE0W				0x6c8U
#define MC_STREAMID_OVERRIDE_CFG_PCIE5R1			0x778U
#define MC_STREAMID_OVERRIDE_CFG_DLA1RDA			0x610U
#define MC_STREAMID_OVERRIDE_CFG_VICSWR				0x368U
#define MC_STREAMID_OVERRIDE_CFG_SESRD				0x400U
#define MC_STREAMID_OVERRIDE_CFG_SDMMCW				0x330U
#define MC_STREAMID_OVERRIDE_CFG_SDMMCRAB			0x318U
#define MC_STREAMID_OVERRIDE_CFG_ISPFALW			0x720U
#define MC_STREAMID_OVERRIDE_CFG_EQOSW				0x478U
#define MC_STREAMID_OVERRIDE_CFG_RCEDMAR			0x6a0U
#define MC_STREAMID_OVERRIDE_CFG_RCER				0x690U
#define MC_STREAMID_OVERRIDE_CFG_NVDECSWR			0x3c8U
#define MC_STREAMID_OVERRIDE_CFG_UFSHCR				0x480U
#define MC_STREAMID_OVERRIDE_CFG_PCIE4W				0x708U
#define MC_STREAMID_OVERRIDE_CFG_VICSRD				0x360U
#define MC_STREAMID_OVERRIDE_CFG_APER				0x3d0U
#define MC_STREAMID_OVERRIDE_CFG_MIU7R				0x8U
#define MC_STREAMID_OVERRIDE_CFG_NVDEC1SRD			0x7c8U
#define MC_STREAMID_OVERRIDE_CFG_MIU7W				0x10U
#define MC_STREAMID_OVERRIDE_CFG_PVA1RDA1			0x768U
#define MC_STREAMID_OVERRIDE_CFG_PVA1WRC			0x688U
#define MC_STREAMID_OVERRIDE_CFG_AONW				0x4c0U
#define MC_STREAMID_OVERRIDE_CFG_MIU4W				0x598U
#define MC_STREAMID_OVERRIDE_CFG_HDAW				0x1a8U
#define MC_STREAMID_OVERRIDE_CFG_BPMPW				0x4a0U
#define MC_STREAMID_OVERRIDE_CFG_DLA1WRA			0x620U
#define MC_STREAMID_OVERRIDE_CFG_DLA0RDA1			0x748U
#define MC_STREAMID_OVERRIDE_CFG_MIU1W				0x548U
#define MC_STREAMID_OVERRIDE_CFG_NVDISPLAYR1			0x508U
#define MC_STREAMID_OVERRIDE_CFG_VICSRD1			0x510U
#define MC_STREAMID_OVERRIDE_CFG_BPMPDMAW			0x4b0U
#define MC_STREAMID_OVERRIDE_CFG_NVDEC1SWR			0x7d8U
#define MC_STREAMID_OVERRIDE_CFG_PVA0WRC			0x658U
#define MC_STREAMID_OVERRIDE_CFG_PCIE5R				0x710U
#define MC_STREAMID_OVERRIDE_CFG_XUSB_DEVR			0x260U
#define MC_STREAMID_OVERRIDE_CFG_UFSHCW				0x488U
#define MC_STREAMID_OVERRIDE_CFG_PVA1WRB			0x680U
#define MC_STREAMID_OVERRIDE_CFG_PVA0WRB			0x650U
#define MC_STREAMID_OVERRIDE_CFG_DLA1FALWRB			0x628U
#define MC_STREAMID_OVERRIDE_CFG_NVENC1SWR			0x6b8U
#define MC_STREAMID_OVERRIDE_CFG_PCIE0R				0x6c0U
#define MC_STREAMID_OVERRIDE_CFG_PCIE3W				0x6f8U
#define MC_STREAMID_OVERRIDE_CFG_PVA0RDA			0x630U
#define MC_STREAMID_OVERRIDE_CFG_MIU6W				0x7f8U
#define MC_STREAMID_OVERRIDE_CFG_PCIE1R				0x6d0U
#define MC_STREAMID_OVERRIDE_CFG_NVDEC1SRD1			0x7d0U
#define MC_STREAMID_OVERRIDE_CFG_DLA0FALWRB			0x608U
#define MC_STREAMID_OVERRIDE_CFG_PVA1RDC			0x670U
#define MC_STREAMID_OVERRIDE_CFG_MIU0W				0x538U
#define MC_STREAMID_OVERRIDE_CFG_MIU2W				0x578U
#define MC_STREAMID_OVERRIDE_CFG_MPCORER			0x138U
#define MC_STREAMID_OVERRIDE_CFG_AXIAPR				0x410U
#define MC_STREAMID_OVERRIDE_CFG_AONR				0x4b8U
#define MC_STREAMID_OVERRIDE_CFG_BPMPDMAR			0x4a8U
#define MC_STREAMID_OVERRIDE_CFG_PVA0RDB			0x638U
#define MC_STREAMID_OVERRIDE_CFG_VIFALW				0x5e8U
#define MC_STREAMID_OVERRIDE_CFG_MIU6R				0x7f0U
#define MC_STREAMID_OVERRIDE_CFG_EQOSR				0x470U
#define MC_STREAMID_OVERRIDE_CFG_NVDECSRD			0x3c0U
#define MC_STREAMID_OVERRIDE_CFG_TSECSRDB			0x430U
#define MC_STREAMID_OVERRIDE_CFG_NVDECSRD1			0x518U
#define MC_STREAMID_OVERRIDE_CFG_PVA0RDB1			0x760U
#define MC_STREAMID_OVERRIDE_CFG_PCIE0R1			0x798U
#define MC_STREAMID_OVERRIDE_CFG_SCEDMAW			0x4f0U
#define MC_STREAMID_OVERRIDE_CFG_APEW				0x3d8U
#define MC_STREAMID_OVERRIDE_CFG_MIU5R				0x7e0U
#define MC_STREAMID_OVERRIDE_CFG_DLA1RDA1			0x750U
#define MC_STREAMID_OVERRIDE_CFG_PVA0WRA			0x648U
#define MC_STREAMID_OVERRIDE_CFG_ISPFALR			0x228U
#define MC_STREAMID_OVERRIDE_CFG_PTCR				0x0U
#define MC_STREAMID_OVERRIDE_CFG_MIU4R				0x590U
#define MC_STREAMID_OVERRIDE_CFG_ISPRA				0x220U
#define MC_STREAMID_OVERRIDE_CFG_VIFALR				0x5e0U
#define MC_STREAMID_OVERRIDE_CFG_PCIE2AR			0x6e0U
#define MC_STREAMID_OVERRIDE_CFG_RCEW				0x698U
#define MC_STREAMID_OVERRIDE_CFG_ISPRA1				0x790U
#define MC_STREAMID_OVERRIDE_CFG_SCEW				0x4e0U
#define MC_STREAMID_OVERRIDE_CFG_MIU3R				0x580U
#define MC_STREAMID_OVERRIDE_CFG_XUSB_DEVW			0x268U
#define MC_STREAMID_OVERRIDE_CFG_SATAR				0xf8U
#define MC_STREAMID_OVERRIDE_CFG_NVDISPLAYR			0x490U
#define MC_STREAMID_OVERRIDE_CFG_PVA1RDB			0x668U
#define MC_STREAMID_OVERRIDE_CFG_VIW				0x390U
#define MC_STREAMID_OVERRIDE_CFG_NVENCSWR			0x158U
#define MC_STREAMID_OVERRIDE_CFG_PCIE5W				0x718U

/*******************************************************************************
 * Macro to calculate Security cfg register addr from StreamID Override register
 ******************************************************************************/
#define MC_STREAMID_OVERRIDE_TO_SECURITY_CFG(addr) ((addr) + (uint32_t)sizeof(uint32_t))

#define MC_TXN_OVERRIDE_CONFIG_COH_PATH_NO_OVERRIDE_SO_DEV		(0U << 4)
#define MC_TXN_OVERRIDE_CONFIG_COH_PATH_FORCE_NON_COHERENT_SO_DEV	(1U << 4)
#define MC_TXN_OVERRIDE_CONFIG_COH_PATH_FORCE_COHERENT_SO_DEV		(2U << 4)
#define MC_TXN_OVERRIDE_CONFIG_COH_PATH_FORCE_COHERENT_SNOOP_SO_DEV	(3U << 4)

#define MC_TXN_OVERRIDE_CONFIG_COH_PATH_NO_OVERRIDE_NORMAL		(0U << 8)
#define MC_TXN_OVERRIDE_CONFIG_COH_PATH_FORCE_NON_COHERENT_NORMAL	(1U << 8)
#define MC_TXN_OVERRIDE_CONFIG_COH_PATH_FORCE_COHERENT_NORMAL		(2U << 8)
#define MC_TXN_OVERRIDE_CONFIG_COH_PATH_FORCE_COHERENT_SNOOP_NORMAL	(3U << 8)

#define MC_TXN_OVERRIDE_CONFIG_CGID_SO_DEV_ZERO				(0U << 12)
#define MC_TXN_OVERRIDE_CONFIG_CGID_SO_DEV_CLIENT_AXI_ID		(1U << 12)

/*******************************************************************************
 * Memory Controller transaction override config registers
 ******************************************************************************/
#define MC_TXN_OVERRIDE_CONFIG_HDAR				0x10a8U
#define MC_TXN_OVERRIDE_CONFIG_DLA1WRA				0x1624U
#define MC_TXN_OVERRIDE_CONFIG_PCIE1W				0x16dcU
#define MC_TXN_OVERRIDE_CONFIG_PVA0RDC				0x1644U
#define MC_TXN_OVERRIDE_CONFIG_PTCR				0x1000U
#define MC_TXN_OVERRIDE_CONFIG_EQOSW				0x1478U
#define MC_TXN_OVERRIDE_CONFIG_MPCOREW				0x11c8U
#define MC_TXN_OVERRIDE_CONFIG_DLA1FALWRB			0x162cU
#define MC_TXN_OVERRIDE_CONFIG_AXISR				0x1460U
#define MC_TXN_OVERRIDE_CONFIG_PVA0WRB				0x1654U
#define MC_TXN_OVERRIDE_CONFIG_MIU6R				0x17f4U
#define MC_TXN_OVERRIDE_CONFIG_MIU5R				0x17e4U
#define MC_TXN_OVERRIDE_CONFIG_NVENCSRD1			0x1784U
#define MC_TXN_OVERRIDE_CONFIG_PCIE0R				0x16c4U
#define MC_TXN_OVERRIDE_CONFIG_EQOSR				0x1470U
#define MC_TXN_OVERRIDE_CONFIG_NVENCSRD				0x10e0U
#define MC_TXN_OVERRIDE_CONFIG_NVENC1SRD1			0x178cU
#define MC_TXN_OVERRIDE_CONFIG_PVA1RDB1				0x1774U
#define MC_TXN_OVERRIDE_CONFIG_NVENC1SWR			0x16bcU
#define MC_TXN_OVERRIDE_CONFIG_VICSRD1				0x1510U
#define MC_TXN_OVERRIDE_CONFIG_BPMPDMAR				0x14a8U
#define MC_TXN_OVERRIDE_CONFIG_VIW				0x1390U
#define MC_TXN_OVERRIDE_CONFIG_PCIE5R				0x1714U
#define MC_TXN_OVERRIDE_CONFIG_AXISW				0x1468U
#define MC_TXN_OVERRIDE_CONFIG_MIU6W				0x17fcU
#define MC_TXN_OVERRIDE_CONFIG_UFSHCR				0x1480U
#define MC_TXN_OVERRIDE_CONFIG_PCIE0R1				0x179cU
#define MC_TXN_OVERRIDE_CONFIG_PVA0RDB1				0x1764U
#define MC_TXN_OVERRIDE_CONFIG_TSECSWR				0x12a8U
#define MC_TXN_OVERRIDE_CONFIG_MIU7R				0x1008U
#define MC_TXN_OVERRIDE_CONFIG_SATAR				0x10f8U
#define MC_TXN_OVERRIDE_CONFIG_XUSB_HOSTW			0x1258U
#define MC_TXN_OVERRIDE_CONFIG_DLA0RDA				0x15f4U
#define MC_TXN_OVERRIDE_CONFIG_TSECSWRB				0x1438U
#define MC_TXN_OVERRIDE_CONFIG_NVDEC1SWR			0x17dcU
#define MC_TXN_OVERRIDE_CONFIG_PVA1RDA1				0x176cU
#define MC_TXN_OVERRIDE_CONFIG_PVA1RDB				0x166cU
#define MC_TXN_OVERRIDE_CONFIG_AONDMAW				0x14d0U
#define MC_TXN_OVERRIDE_CONFIG_AONW				0x14c0U
#define MC_TXN_OVERRIDE_CONFIG_ETRR				0x1420U
#define MC_TXN_OVERRIDE_CONFIG_PCIE2AW				0x16ecU
#define MC_TXN_OVERRIDE_CONFIG_PCIE1R				0x16d4U
#define MC_TXN_OVERRIDE_CONFIG_PVA1RDC				0x1674U
#define MC_TXN_OVERRIDE_CONFIG_PVA0WRA				0x164cU
#define MC_TXN_OVERRIDE_CONFIG_TSECSRDB				0x1430U
#define MC_TXN_OVERRIDE_CONFIG_MIU1W				0x1548U
#define MC_TXN_OVERRIDE_CONFIG_PCIE0W				0x16ccU
#define MC_TXN_OVERRIDE_CONFIG_NVDEC1SRD			0x17ccU
#define MC_TXN_OVERRIDE_CONFIG_MIU7W				0x1010U
#define MC_TXN_OVERRIDE_CONFIG_NVDECSRD1			0x1518U
#define MC_TXN_OVERRIDE_CONFIG_MIU3R				0x1580U
#define MC_TXN_OVERRIDE_CONFIG_MIU3W				0x158cU
#define MC_TXN_OVERRIDE_CONFIG_XUSB_HOSTR			0x1250U
#define MC_TXN_OVERRIDE_CONFIG_SESRD				0x1400U
#define MC_TXN_OVERRIDE_CONFIG_SCER				0x14d8U
#define MC_TXN_OVERRIDE_CONFIG_MPCORER				0x1138U
#define MC_TXN_OVERRIDE_CONFIG_SDMMCWA				0x1320U
#define MC_TXN_OVERRIDE_CONFIG_HDAW				0x11a8U
#define MC_TXN_OVERRIDE_CONFIG_NVDECSWR				0x13c8U
#define MC_TXN_OVERRIDE_CONFIG_PVA0RDA				0x1634U
#define MC_TXN_OVERRIDE_CONFIG_AONDMAR				0x14c8U
#define MC_TXN_OVERRIDE_CONFIG_SDMMCWAB				0x1338U
#define MC_TXN_OVERRIDE_CONFIG_ISPFALR				0x1228U
#define MC_TXN_OVERRIDE_CONFIG_PVA0RDA1				0x175cU
#define MC_TXN_OVERRIDE_CONFIG_NVENC1SRD			0x16b4U
#define MC_TXN_OVERRIDE_CONFIG_NVDISPLAYR1			0x1508U
#define MC_TXN_OVERRIDE_CONFIG_PVA1RDA				0x1664U
#define MC_TXN_OVERRIDE_CONFIG_DLA0RDA1				0x174cU
#define MC_TXN_OVERRIDE_CONFIG_ISPWB				0x1238U
#define MC_TXN_OVERRIDE_CONFIG_APEW				0x13d8U
#define MC_TXN_OVERRIDE_CONFIG_AXIAPR				0x1410U
#define MC_TXN_OVERRIDE_CONFIG_PCIE2AR				0x16e4U
#define MC_TXN_OVERRIDE_CONFIG_ISPFALW				0x1724U
#define MC_TXN_OVERRIDE_CONFIG_SDMMCR				0x1310U
#define MC_TXN_OVERRIDE_CONFIG_MIU2W				0x1578U
#define MC_TXN_OVERRIDE_CONFIG_RCER				0x1694U
#define MC_TXN_OVERRIDE_CONFIG_PCIE4W				0x170cU
#define MC_TXN_OVERRIDE_CONFIG_BPMPW				0x14a0U
#define MC_TXN_OVERRIDE_CONFIG_NVDISPLAYR			0x1490U
#define MC_TXN_OVERRIDE_CONFIG_ISPRA				0x1220U
#define MC_TXN_OVERRIDE_CONFIG_NVJPGSWR				0x13f8U
#define MC_TXN_OVERRIDE_CONFIG_VICSRD				0x1360U
#define MC_TXN_OVERRIDE_CONFIG_NVDEC1SRD1			0x17d4U
#define MC_TXN_OVERRIDE_CONFIG_DLA1RDA				0x1614U
#define MC_TXN_OVERRIDE_CONFIG_SCEDMAW				0x14f0U
#define MC_TXN_OVERRIDE_CONFIG_SDMMCW				0x1330U
#define MC_TXN_OVERRIDE_CONFIG_DLA1FALRDB			0x161cU
#define MC_TXN_OVERRIDE_CONFIG_APEDMAR				0x14f8U
#define MC_TXN_OVERRIDE_CONFIG_RCEW				0x169cU
#define MC_TXN_OVERRIDE_CONFIG_SDMMCRAB				0x1318U
#define MC_TXN_OVERRIDE_CONFIG_DLA0WRA				0x1604U
#define MC_TXN_OVERRIDE_CONFIG_VIFALR				0x15e4U
#define MC_TXN_OVERRIDE_CONFIG_PCIE3R				0x16f4U
#define MC_TXN_OVERRIDE_CONFIG_MIU1R				0x1540U
#define MC_TXN_OVERRIDE_CONFIG_PCIE5W				0x171cU
#define MC_TXN_OVERRIDE_CONFIG_XUSB_DEVR			0x1260U
#define MC_TXN_OVERRIDE_CONFIG_MIU0W				0x1538U
#define MC_TXN_OVERRIDE_CONFIG_DLA0FALWRB			0x160cU
#define MC_TXN_OVERRIDE_CONFIG_VIFALW				0x15ecU
#define MC_TXN_OVERRIDE_CONFIG_DLA0FALRDB			0x15fcU
#define MC_TXN_OVERRIDE_CONFIG_PCIE3W				0x16fcU
#define MC_TXN_OVERRIDE_CONFIG_MIU0R				0x1530U
#define MC_TXN_OVERRIDE_CONFIG_PVA0WRC				0x165cU
#define MC_TXN_OVERRIDE_CONFIG_SCEDMAR				0x14e8U
#define MC_TXN_OVERRIDE_CONFIG_APEDMAW				0x1500U
#define MC_TXN_OVERRIDE_CONFIG_HOST1XDMAR			0x10b0U
#define MC_TXN_OVERRIDE_CONFIG_SESWR				0x1408U
#define MC_TXN_OVERRIDE_CONFIG_AXIAPW				0x1418U
#define MC_TXN_OVERRIDE_CONFIG_MIU4R				0x1594U
#define MC_TXN_OVERRIDE_CONFIG_MIU4W				0x159cU
#define MC_TXN_OVERRIDE_CONFIG_NVJPGSRD				0x13f0U
#define MC_TXN_OVERRIDE_CONFIG_NVDECSRD				0x13c0U
#define MC_TXN_OVERRIDE_CONFIG_BPMPDMAW				0x14b0U
#define MC_TXN_OVERRIDE_CONFIG_APER				0x13d0U
#define MC_TXN_OVERRIDE_CONFIG_DLA1RDA1				0x1754U
#define MC_TXN_OVERRIDE_CONFIG_PVA1WRB				0x1684U
#define MC_TXN_OVERRIDE_CONFIG_ISPWA				0x1230U
#define MC_TXN_OVERRIDE_CONFIG_PVA1WRC				0x168cU
#define MC_TXN_OVERRIDE_CONFIG_RCEDMAR				0x16a4U
#define MC_TXN_OVERRIDE_CONFIG_ISPRA1				0x1794U
#define MC_TXN_OVERRIDE_CONFIG_AONR				0x14b8U
#define MC_TXN_OVERRIDE_CONFIG_RCEDMAW				0x16acU
#define MC_TXN_OVERRIDE_CONFIG_UFSHCW				0x1488U
#define MC_TXN_OVERRIDE_CONFIG_ETRW				0x1428U
#define MC_TXN_OVERRIDE_CONFIG_SATAW				0x11e8U
#define MC_TXN_OVERRIDE_CONFIG_VICSWR				0x1368U
#define MC_TXN_OVERRIDE_CONFIG_NVENCSWR				0x1158U
#define MC_TXN_OVERRIDE_CONFIG_PCIE5R1				0x177cU
#define MC_TXN_OVERRIDE_CONFIG_PVA0RDB				0x163cU
#define MC_TXN_OVERRIDE_CONFIG_SDMMCRA				0x1300U
#define MC_TXN_OVERRIDE_CONFIG_PVA1WRA				0x167cU
#define MC_TXN_OVERRIDE_CONFIG_MIU5W				0x17ecU
#define MC_TXN_OVERRIDE_CONFIG_BPMPR				0x1498U
#define MC_TXN_OVERRIDE_CONFIG_MIU2R				0x1570U
#define MC_TXN_OVERRIDE_CONFIG_XUSB_DEVW			0x1268U
#define MC_TXN_OVERRIDE_CONFIG_TSECSRD				0x12a0U
#define MC_TXN_OVERRIDE_CONFIG_PCIE4R				0x1704U
#define MC_TXN_OVERRIDE_CONFIG_SCEW				0x14e0U

#define MC_TXN_OVERRIDE_CONFIG_AXID_OVERRIDE_CGID			(1U << 0)
#define MC_TXN_OVERRIDE_CONFIG_COH_PATH_OVERRIDE_SO_DEV			(2U << 4)
#define MC_TXN_OVERRIDE_CONFIG_AXID_OVERRIDE_SO_DEV_CGID_SO_DEV_CLIENT	(1U << 12)

/*******************************************************************************
 * Non-SO_DEV transactions override values for CGID_TAG bitfield for the
 * MC_TXN_OVERRIDE_CONFIG_{module} registers
 ******************************************************************************/
#define MC_TXN_OVERRIDE_CGID_TAG_DEFAULT			0U
#define MC_TXN_OVERRIDE_CGID_TAG_CLIENT_AXI_ID			1U
#define MC_TXN_OVERRIDE_CGID_TAG_ZERO				2U
#define MC_TXN_OVERRIDE_CGID_TAG_ADR				3U
#define MC_TXN_OVERRIDE_CGID_TAG_MASK				3ULL

/*******************************************************************************
 * Memory Controller Reset Control registers
 ******************************************************************************/
#define MC_CLIENT_HOTRESET_CTRL0				0x200U
#define  MC_CLIENT_HOTRESET_CTRL0_RESET_VAL			0U
#define  MC_CLIENT_HOTRESET_CTRL0_AFI_FLUSH_ENB			(1U << 0)
#define  MC_CLIENT_HOTRESET_CTRL0_HC_FLUSH_ENB			(1U << 6)
#define  MC_CLIENT_HOTRESET_CTRL0_HDA_FLUSH_ENB			(1U << 7)
#define  MC_CLIENT_HOTRESET_CTRL0_ISP2_FLUSH_ENB		(1U << 8)
#define  MC_CLIENT_HOTRESET_CTRL0_MPCORE_FLUSH_ENB		(1U << 9)
#define  MC_CLIENT_HOTRESET_CTRL0_NVENC_FLUSH_ENB		(1U << 11)
#define  MC_CLIENT_HOTRESET_CTRL0_SATA_FLUSH_ENB		(1U << 15)
#define  MC_CLIENT_HOTRESET_CTRL0_VI_FLUSH_ENB			(1U << 17)
#define  MC_CLIENT_HOTRESET_CTRL0_VIC_FLUSH_ENB			(1U << 18)
#define  MC_CLIENT_HOTRESET_CTRL0_XUSB_HOST_FLUSH_ENB		(1U << 19)
#define  MC_CLIENT_HOTRESET_CTRL0_XUSB_DEV_FLUSH_ENB		(1U << 20)
#define  MC_CLIENT_HOTRESET_CTRL0_TSEC_FLUSH_ENB		(1U << 22)
#define  MC_CLIENT_HOTRESET_CTRL0_SDMMC1A_FLUSH_ENB		(1U << 29)
#define  MC_CLIENT_HOTRESET_CTRL0_SDMMC2A_FLUSH_ENB		(1U << 30)
#define  MC_CLIENT_HOTRESET_CTRL0_SDMMC3A_FLUSH_ENB		(1U << 31)
#define MC_CLIENT_HOTRESET_STATUS0				0x204U
#define MC_CLIENT_HOTRESET_CTRL1				0x970U
#define  MC_CLIENT_HOTRESET_CTRL1_RESET_VAL			0U
#define  MC_CLIENT_HOTRESET_CTRL1_SDMMC4A_FLUSH_ENB		(1U << 0)
#define  MC_CLIENT_HOTRESET_CTRL1_GPU_FLUSH_ENB			(1U << 2)
#define  MC_CLIENT_HOTRESET_CTRL1_NVDEC_FLUSH_ENB		(1U << 5)
#define  MC_CLIENT_HOTRESET_CTRL1_APE_FLUSH_ENB			(1U << 6)
#define  MC_CLIENT_HOTRESET_CTRL1_SE_FLUSH_ENB			(1U << 7)
#define  MC_CLIENT_HOTRESET_CTRL1_NVJPG_FLUSH_ENB		(1U << 8)
#define  MC_CLIENT_HOTRESET_CTRL1_ETR_FLUSH_ENB			(1U << 12)
#define  MC_CLIENT_HOTRESET_CTRL1_TSECB_FLUSH_ENB		(1U << 13)
#define  MC_CLIENT_HOTRESET_CTRL1_AXIS_FLUSH_ENB		(1U << 17)
#define  MC_CLIENT_HOTRESET_CTRL1_EQOS_FLUSH_ENB		(1U << 18)
#define  MC_CLIENT_HOTRESET_CTRL1_UFSHC_FLUSH_ENB		(1U << 19)
#define  MC_CLIENT_HOTRESET_CTRL1_NVDISPLAY_FLUSH_ENB		(1U << 20)
#define  MC_CLIENT_HOTRESET_CTRL1_BPMP_FLUSH_ENB		(1U << 21)
#define  MC_CLIENT_HOTRESET_CTRL1_AON_FLUSH_ENB			(1U << 22)
#define  MC_CLIENT_HOTRESET_CTRL1_SCE_FLUSH_ENB			(1U << 23)
#define  MC_CLIENT_HOTRESET_CTRL1_VIFAL_FLUSH_ENB		(1U << 26)
#define  MC_CLIENT_HOTRESET_CTRL1_RCE_FLUSH_ENB			(1U << 31)
#define MC_CLIENT_HOTRESET_STATUS1				0x974U
#define MC_CLIENT_HOTRESET_CTRL2				0x97cU
#define  MC_CLIENT_HOTRESET_CTRL2_RESET_VAL			0U
#define  MC_CLIENT_HOTRESET_CTRL2_RCEDMA_FLUSH_ENB		(1U << 0)
#define  MC_CLIENT_HOTRESET_CTRL2_PCIE_FLUSH_ENB		(1U << 2)
#define  MC_CLIENT_HOTRESET_CTRL2_PCIE5A_FLUSH_ENB		(1U << 4)
#define  MC_CLIENT_HOTRESET_CTRL2_AONDMA_FLUSH_ENB		(1U << 9)
#define  MC_CLIENT_HOTRESET_CTRL2_BPMPDMA_FLUSH_ENB		(1U << 10)
#define  MC_CLIENT_HOTRESET_CTRL2_SCEDMA_FLUSH_ENB		(1U << 11)
#define  MC_CLIENT_HOTRESET_CTRL2_APEDMA_FLUSH_ENB		(1U << 14)
#define  MC_CLIENT_HOTRESET_CTRL2_PCIE3A_FLUSH_ENB		(1U << 16)
#define  MC_CLIENT_HOTRESET_CTRL2_PCIE3_FLUSH_ENB		(1U << 17)
#define  MC_CLIENT_HOTRESET_CTRL2_PCIE0A_FLUSH_ENB		(1U << 22)
#define  MC_CLIENT_HOTRESET_CTRL2_PCIE0A2_FLUSH_ENB		(1U << 23)
#define  MC_CLIENT_HOTRESET_CTRL2_PCIE4A_FLUSH_ENB		(1U << 25)
#define MC_CLIENT_HOTRESET_STATUS2				0x1898U

#define MC_COALESCE_CTRL					0x2930U
#define  MC_COALESCE_CTRL_COALESCER_ENABLE			(1U << 31)

/*******************************************************************************
 * Tegra TSA Controller constants
 ******************************************************************************/
#define TEGRA_TSA_BASE						U(0x02000000)

#define TSA_CONFIG_STATIC0_CSR_RESET_R				0x20000000U
#define TSA_CONFIG_STATIC0_CSW_RESET_W				0x20001000U
#define TSA_CONFIG_STATIC0_CSW_RESET_SO_DEV			0x20001000U

#define TSA_CONFIG_STATIC0_CSW_PCIE1W				0x1004U
#define TSA_CONFIG_STATIC0_CSW_PCIE2AW				0x1008U
#define TSA_CONFIG_STATIC0_CSW_PCIE3W				0x100cU
#define TSA_CONFIG_STATIC0_CSW_PCIE4W				0x1028U
#define TSA_CONFIG_STATIC0_CSW_XUSB_DEVW			0x2004U
#define TSA_CONFIG_STATIC0_CSR_SATAR				0x2010U
#define TSA_CONFIG_STATIC0_CSW_SATAW				0x2014U
#define TSA_CONFIG_STATIC0_CSW_PCIE0W				0x2020U
#define TSA_CONFIG_STATIC0_CSW_XUSB_HOSTW			0x202cU
#define TSA_CONFIG_STATIC0_CSW_NVENC1SWR			0x3004U
#define TSA_CONFIG_STATIC0_CSW_NVENCSWR				0x3010U
#define TSA_CONFIG_STATIC0_CSW_NVDEC1SWR			0x4004U
#define TSA_CONFIG_STATIC0_CSR_ISPFALR				0x4010U
#define TSA_CONFIG_STATIC0_CSW_ISPWA				0x4014U
#define TSA_CONFIG_STATIC0_CSW_ISPWB				0x4018U
#define TSA_CONFIG_STATIC0_CSW_ISPFALW				0x401cU
#define TSA_CONFIG_STATIC0_CSW_NVDECSWR				0x5004U
#define TSA_CONFIG_STATIC0_CSR_EQOSR				0x5010U
#define TSA_CONFIG_STATIC0_CSW_EQOSW				0x5014U
#define TSA_CONFIG_STATIC0_CSR_SDMMCRAB				0x5020U
#define TSA_CONFIG_STATIC0_CSW_SDMMCWAB				0x5024U
#define TSA_CONFIG_STATIC0_CSW_UFSHCW				0x6004U
#define TSA_CONFIG_STATIC0_CSR_SDMMCR				0x6010U
#define TSA_CONFIG_STATIC0_CSR_SDMMCRA				0x6014U
#define TSA_CONFIG_STATIC0_CSW_SDMMCW				0x6018U
#define TSA_CONFIG_STATIC0_CSW_SDMMCWA				0x601cU
#define TSA_CONFIG_STATIC0_CSR_RCER				0x6030U
#define TSA_CONFIG_STATIC0_CSR_RCEDMAR				0x6034U
#define TSA_CONFIG_STATIC0_CSW_RCEW				0x6038U
#define TSA_CONFIG_STATIC0_CSW_RCEDMAW				0x603cU
#define TSA_CONFIG_STATIC0_CSR_SCER				0x6050U
#define TSA_CONFIG_STATIC0_CSR_SCEDMAR				0x6054U
#define TSA_CONFIG_STATIC0_CSW_SCEW				0x6058U
#define TSA_CONFIG_STATIC0_CSW_SCEDMAW				0x605cU
#define TSA_CONFIG_STATIC0_CSR_AXIAPR				0x7004U
#define TSA_CONFIG_STATIC0_CSR_ETRR				0x7008U
#define TSA_CONFIG_STATIC0_CSR_HOST1XDMAR			0x700cU
#define TSA_CONFIG_STATIC0_CSW_AXIAPW				0x7010U
#define TSA_CONFIG_STATIC0_CSW_ETRW				0x7014U
#define TSA_CONFIG_STATIC0_CSR_NVJPGSRD				0x8004U
#define TSA_CONFIG_STATIC0_CSW_NVJPGSWR				0x8008U
#define TSA_CONFIG_STATIC0_CSR_AXISR				0x8014U
#define TSA_CONFIG_STATIC0_CSW_AXISW				0x8018U
#define TSA_CONFIG_STATIC0_CSR_BPMPR				0x9004U
#define TSA_CONFIG_STATIC0_CSR_BPMPDMAR				0x9008U
#define TSA_CONFIG_STATIC0_CSW_BPMPW				0x900cU
#define TSA_CONFIG_STATIC0_CSW_BPMPDMAW				0x9010U
#define TSA_CONFIG_STATIC0_CSR_SESRD				0x9024U
#define TSA_CONFIG_STATIC0_CSR_TSECSRD				0x9028U
#define TSA_CONFIG_STATIC0_CSR_TSECSRDB				0x902cU
#define TSA_CONFIG_STATIC0_CSW_SESWR				0x9030U
#define TSA_CONFIG_STATIC0_CSW_TSECSWR				0x9034U
#define TSA_CONFIG_STATIC0_CSW_TSECSWRB				0x9038U
#define TSA_CONFIG_STATIC0_CSW_PCIE5W				0xb004U
#define TSA_CONFIG_STATIC0_CSW_VICSWR				0xc004U
#define TSA_CONFIG_STATIC0_CSR_APER				0xd004U
#define TSA_CONFIG_STATIC0_CSR_APEDMAR				0xd008U
#define TSA_CONFIG_STATIC0_CSW_APEW				0xd00cU
#define TSA_CONFIG_STATIC0_CSW_APEDMAW				0xd010U
#define TSA_CONFIG_STATIC0_CSR_HDAR				0xf004U
#define TSA_CONFIG_STATIC0_CSW_HDAW				0xf008U
#define TSA_CONFIG_STATIC0_CSR_NVDISPLAYR			0xf014U
#define TSA_CONFIG_STATIC0_CSR_VIFALR				0x10004U
#define TSA_CONFIG_STATIC0_CSW_VIW				0x10008U
#define TSA_CONFIG_STATIC0_CSW_VIFALW				0x1000cU
#define TSA_CONFIG_STATIC0_CSR_AONR				0x12004U
#define TSA_CONFIG_STATIC0_CSR_AONDMAR				0x12008U
#define TSA_CONFIG_STATIC0_CSW_AONW				0x1200cU
#define TSA_CONFIG_STATIC0_CSW_AONDMAW				0x12010U
#define TSA_CONFIG_STATIC0_CSR_PCIE1R				0x14004U
#define TSA_CONFIG_STATIC0_CSR_PCIE2AR				0x14008U
#define TSA_CONFIG_STATIC0_CSR_PCIE3R				0x1400cU
#define TSA_CONFIG_STATIC0_CSR_PCIE4R				0x14028U
#define TSA_CONFIG_STATIC0_CSR_XUSB_DEVR			0x15004U
#define TSA_CONFIG_STATIC0_CSR_XUSB_HOSTR			0x15010U
#define TSA_CONFIG_STATIC0_CSR_UFSHCR				0x16004U
#define TSA_CONFIG_STATIC0_CSW_DLA1WRA				0x18004U
#define TSA_CONFIG_STATIC0_CSR_DLA1FALRDB			0x18010U
#define TSA_CONFIG_STATIC0_CSW_DLA1FALWRB			0x18014U
#define TSA_CONFIG_STATIC0_CSW_DLA0WRA				0x19004U
#define TSA_CONFIG_STATIC0_CSR_DLA0FALRDB			0x19010U
#define TSA_CONFIG_STATIC0_CSW_DLA0FALWRB			0x19014U
#define TSA_CONFIG_STATIC0_CSR_PVA1RDC				0x1a004U
#define TSA_CONFIG_STATIC0_CSW_PVA1WRC				0x1a008U
#define TSA_CONFIG_STATIC0_CSW_PVA1WRA				0x1a014U
#define TSA_CONFIG_STATIC0_CSW_PVA1WRB				0x1a020U
#define TSA_CONFIG_STATIC0_CSW_PVA0WRB				0x1b004U
#define TSA_CONFIG_STATIC0_CSR_PVA0RDC				0x1b010U
#define TSA_CONFIG_STATIC0_CSW_PVA0WRC				0x1b014U
#define TSA_CONFIG_STATIC0_CSW_PVA0WRA				0x1b020U
#define TSA_CONFIG_STATIC0_CSR_NVENC1SRD			0x1d004U
#define TSA_CONFIG_STATIC0_CSR_NVENCSRD				0x1d010U
#define TSA_CONFIG_STATIC0_CSR_NVDEC1SRD			0x1e004U
#define TSA_CONFIG_STATIC0_CSR_ISPRA				0x1e010U
#define TSA_CONFIG_STATIC0_CSR_NVDECSRD				0x1f004U
#define TSA_CONFIG_STATIC0_CSR_PCIE0R				0x21004U
#define TSA_CONFIG_STATIC0_CSR_PCIE5R				0x23004U
#define TSA_CONFIG_STATIC0_CSR_VICSRD				0x24004U
#define TSA_CONFIG_STATIC0_CSR_DLA1RDA				0x26004U
#define TSA_CONFIG_STATIC0_CSR_DLA0RDA				0x27004U
#define TSA_CONFIG_STATIC0_CSR_PVA1RDA				0x28004U
#define TSA_CONFIG_STATIC0_CSR_PVA1RDB				0x28010U
#define TSA_CONFIG_STATIC0_CSR_PVA0RDB				0x29004U
#define TSA_CONFIG_STATIC0_CSR_PVA0RDA				0x29010U

#define TSA_CONFIG_CSW_MEMTYPE_OVERRIDE_MASK			(ULL(0x3) << 11)
#define TSA_CONFIG_CSW_MEMTYPE_OVERRIDE_PASTHRU			(ULL(0) << 11)

#endif /* TEGRA_MC_DEF_H */
