/*
 * Copyright (c) 2016-2017, ARM Limited and Contributors. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of ARM nor the names of its contributors may be used
 * to endorse or promote products derived from this software without specific
 * prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef T18X_TEGRA_ARI_H
#define T18X_TEGRA_ARI_H

/*
 * ----------------------------------------------------------------------------
 * t18x_ari.h
 *
 * Global ARI definitions.
 * ----------------------------------------------------------------------------
 */

enum {
	TEGRA_ARI_VERSION_MAJOR = 3U,
	TEGRA_ARI_VERSION_MINOR = 1U,
};

typedef enum {
	/* indexes below get the core lock */
	TEGRA_ARI_MISC = 0U,
	/* index 1 is deprecated */
	/* index 2 is deprecated */
	/* index 3 is deprecated */
	TEGRA_ARI_ONLINE_CORE = 4U,

	/* indexes below need cluster lock */
	TEGRA_ARI_MISC_CLUSTER = 41U,
	TEGRA_ARI_IS_CCX_ALLOWED = 42U,
	TEGRA_ARI_CC3_CTRL = 43U,

	/* indexes below need ccplex lock */
	TEGRA_ARI_ENTER_CSTATE = 80U,
	TEGRA_ARI_UPDATE_CSTATE_INFO = 81U,
	TEGRA_ARI_IS_SC7_ALLOWED = 82U,
	/* index 83 is deprecated */
	TEGRA_ARI_PERFMON = 84U,
	TEGRA_ARI_UPDATE_CCPLEX_GSC = 85U,
	/* index 86 is depracated */
	/* index 87 is deprecated */
	TEGRA_ARI_ROC_FLUSH_CACHE_ONLY = 88U,
	TEGRA_ARI_ROC_FLUSH_CACHE_TRBITS = 89U,
	TEGRA_ARI_MISC_CCPLEX = 90U,
	TEGRA_ARI_MCA = 91U,
	TEGRA_ARI_UPDATE_CROSSOVER = 92U,
	TEGRA_ARI_CSTATE_STATS = 93U,
	TEGRA_ARI_WRITE_CSTATE_STATS = 94U,
	TEGRA_ARI_COPY_MISCREG_AA64_RST = 95U,
	TEGRA_ARI_ROC_CLEAN_CACHE_ONLY = 96U,
} tegra_ari_req_id_t;

typedef enum {
	TEGRA_ARI_MISC_ECHO = 0U,
	TEGRA_ARI_MISC_VERSION = 1U,
	TEGRA_ARI_MISC_FEATURE_LEAF_0 = 2U,
} tegra_ari_misc_index_t;

typedef enum {
	TEGRA_ARI_MISC_CCPLEX_SHUTDOWN_POWER_OFF = 0U,
	TEGRA_ARI_MISC_CCPLEX_SHUTDOWN_REBOOT = 1U,
	TEGRA_ARI_MISC_CCPLEX_CORESIGHT_CG_CTRL = 2U,
	TEGRA_ARI_MISC_CCPLEX_EDBGREQ = 3U,
} tegra_ari_misc_ccplex_index_t;

typedef enum {
	TEGRA_ARI_CORE_C0 = 0U,
	TEGRA_ARI_CORE_C1 = 1U,
	TEGRA_ARI_CORE_C6 = 6U,
	TEGRA_ARI_CORE_C7 = 7U,
	TEGRA_ARI_CORE_WARMRSTREQ = 8U,
} tegra_ari_core_sleep_state_t;

typedef enum {
	TEGRA_ARI_CLUSTER_CC0 = 0U,
	TEGRA_ARI_CLUSTER_CC1 = 1U,
	TEGRA_ARI_CLUSTER_CC6 = 6U,
	TEGRA_ARI_CLUSTER_CC7 = 7U,
} tegra_ari_cluster_sleep_state_t;

typedef enum {
	TEGRA_ARI_CCPLEX_CCP0 = 0U,
	TEGRA_ARI_CCPLEX_CCP1 = 1U,
	TEGRA_ARI_CCPLEX_CCP3 = 3U,  /* obsoleted */
} tegra_ari_ccplex_sleep_state_t;

typedef enum {
	TEGRA_ARI_SYSTEM_SC0 = 0U,
	TEGRA_ARI_SYSTEM_SC1 = 1U,  /* obsoleted */
	TEGRA_ARI_SYSTEM_SC2 = 2U,  /* obsoleted */
	TEGRA_ARI_SYSTEM_SC3 = 3U,  /* obsoleted */
	TEGRA_ARI_SYSTEM_SC4 = 4U,  /* obsoleted */
	TEGRA_ARI_SYSTEM_SC7 = 7U,
	TEGRA_ARI_SYSTEM_SC8 = 8U,
} tegra_ari_system_sleep_state_t;

typedef enum {
	TEGRA_ARI_CROSSOVER_C1_C6 = 0U,
	TEGRA_ARI_CROSSOVER_CC1_CC6 = 1U,
	TEGRA_ARI_CROSSOVER_CC1_CC7 = 2U,
	TEGRA_ARI_CROSSOVER_CCP1_CCP3 = 3U,  /* obsoleted */
	TEGRA_ARI_CROSSOVER_CCP3_SC2 = 4U,  /* obsoleted */
	TEGRA_ARI_CROSSOVER_CCP3_SC3 = 5U,  /* obsoleted */
	TEGRA_ARI_CROSSOVER_CCP3_SC4 = 6U,  /* obsoleted */
	TEGRA_ARI_CROSSOVER_CCP3_SC7 = 7U,  /* obsoleted */
	TEGRA_ARI_CROSSOVER_SC0_SC7 = 7U,
	TEGRA_ARI_CROSSOVER_CCP3_SC1 = 8U,  /* obsoleted */
} tegra_ari_crossover_index_t;

typedef enum {
	TEGRA_ARI_CSTATE_STATS_CLEAR = 0U,
	TEGRA_ARI_CSTATE_STATS_SC7_ENTRIES = 1U,
	TEGRA_ARI_CSTATE_STATS_SC4_ENTRIES, /* obsoleted */
	TEGRA_ARI_CSTATE_STATS_SC3_ENTRIES, /* obsoleted */
	TEGRA_ARI_CSTATE_STATS_SC2_ENTRIES, /* obsoleted */
	TEGRA_ARI_CSTATE_STATS_CCP3_ENTRIES, /* obsoleted */
	TEGRA_ARI_CSTATE_STATS_A57_CC6_ENTRIES,
	TEGRA_ARI_CSTATE_STATS_A57_CC7_ENTRIES,
	TEGRA_ARI_CSTATE_STATS_D15_CC6_ENTRIES,
	TEGRA_ARI_CSTATE_STATS_D15_CC7_ENTRIES,
	TEGRA_ARI_CSTATE_STATS_D15_0_C6_ENTRIES,
	TEGRA_ARI_CSTATE_STATS_D15_1_C6_ENTRIES,
	TEGRA_ARI_CSTATE_STATS_D15_0_C7_ENTRIES = 14U,
	TEGRA_ARI_CSTATE_STATS_D15_1_C7_ENTRIES,
	TEGRA_ARI_CSTATE_STATS_A57_0_C7_ENTRIES = 18U,
	TEGRA_ARI_CSTATE_STATS_A57_1_C7_ENTRIES,
	TEGRA_ARI_CSTATE_STATS_A57_2_C7_ENTRIES,
	TEGRA_ARI_CSTATE_STATS_A57_3_C7_ENTRIES,
	TEGRA_ARI_CSTATE_STATS_LAST_CSTATE_ENTRY_D15_0,
	TEGRA_ARI_CSTATE_STATS_LAST_CSTATE_ENTRY_D15_1,
	TEGRA_ARI_CSTATE_STATS_LAST_CSTATE_ENTRY_A57_0 = 26U,
	TEGRA_ARI_CSTATE_STATS_LAST_CSTATE_ENTRY_A57_1,
	TEGRA_ARI_CSTATE_STATS_LAST_CSTATE_ENTRY_A57_2,
	TEGRA_ARI_CSTATE_STATS_LAST_CSTATE_ENTRY_A57_3,
} tegra_ari_cstate_stats_index_t;

typedef enum {
	TEGRA_ARI_GSC_ALL = 0U,
	TEGRA_ARI_GSC_BPMP = 6U,
	TEGRA_ARI_GSC_APE = 7U,
	TEGRA_ARI_GSC_SPE = 8U,
	TEGRA_ARI_GSC_SCE = 9U,
	TEGRA_ARI_GSC_APR = 10U,
	TEGRA_ARI_GSC_TZRAM = 11U,
	TEGRA_ARI_GSC_SE = 12U,
	TEGRA_ARI_GSC_BPMP_TO_SPE = 16U,
	TEGRA_ARI_GSC_SPE_TO_BPMP = 17U,
	TEGRA_ARI_GSC_CPU_TZ_TO_BPMP = 18U,
	TEGRA_ARI_GSC_BPMP_TO_CPU_TZ = 19U,
	TEGRA_ARI_GSC_CPU_NS_TO_BPMP = 20U,
	TEGRA_ARI_GSC_BPMP_TO_CPU_NS = 21U,
	TEGRA_ARI_GSC_IPC_SE_SPE_SCE_BPMP = 22U,
	TEGRA_ARI_GSC_SC7_RESUME_FW = 23U,
	TEGRA_ARI_GSC_TZ_DRAM_IDX = 34U,
	TEGRA_ARI_GSC_VPR_IDX = 35U,
} tegra_ari_gsc_index_t;

/* This macro will produce enums for __name##_LSB, __name##_MSB and __name##_MSK */
#define TEGRA_ARI_ENUM_MASK_LSB_MSB(__name, __lsb, __msb) __name##_LSB = __lsb, __name##_MSB = __msb

typedef enum {
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_UPDATE_CSTATE_INFO__CLUSTER_CSTATE, 0U, 2U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_UPDATE_CSTATE_INFO__CLUSTER_CSTATE_PRESENT, 7U, 7U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_UPDATE_CSTATE_INFO__CCPLEX_CSTATE, 8U, 9U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_UPDATE_CSTATE_INFO__CCPLEX_CSTATE_PRESENT, 15U, 15U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_UPDATE_CSTATE_INFO__SYSTEM_CSTATE, 16U, 19U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_UPDATE_CSTATE_INFO__IGNORE_CROSSOVERS, 22U, 22U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_UPDATE_CSTATE_INFO__SYSTEM_CSTATE_PRESENT, 23U, 23U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_UPDATE_CSTATE_INFO__WAKE_MASK_PRESENT, 31U, 31U),
} tegra_ari_update_cstate_info_bitmasks_t;

typedef enum {
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MISC_CCPLEX_CORESIGHT_CG_CTRL__EN, 0U, 0U),
} tegra_ari_misc_ccplex_bitmasks_t;

typedef enum {
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_CC3_CTRL__IDLE_FREQ, 0U, 8U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_CC3_CTRL__IDLE_VOLT, 16U, 23U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_CC3_CTRL__ENABLE, 31U, 31U),
} tegra_ari_cc3_ctrl_bitmasks_t;

typedef enum {
	TEGRA_ARI_MCA_NOP = 0U,
	TEGRA_ARI_MCA_READ_SERR = 1U,
	TEGRA_ARI_MCA_WRITE_SERR = 2U,
	TEGRA_ARI_MCA_CLEAR_SERR = 4U,
	TEGRA_ARI_MCA_REPORT_SERR = 5U,
	TEGRA_ARI_MCA_READ_INTSTS = 6U,
	TEGRA_ARI_MCA_WRITE_INTSTS = 7U,
	TEGRA_ARI_MCA_READ_PREBOOT_SERR = 8U,
} tegra_ari_mca_commands_t;

typedef enum {
	TEGRA_ARI_MCA_RD_WR_DPMU = 0U,
	TEGRA_ARI_MCA_RD_WR_IOB = 1U,
	TEGRA_ARI_MCA_RD_WR_MCB = 2U,
	TEGRA_ARI_MCA_RD_WR_CCE = 3U,
	TEGRA_ARI_MCA_RD_WR_CQX = 4U,
	TEGRA_ARI_MCA_RD_WR_CTU = 5U,
	TEGRA_ARI_MCA_RD_WR_JSR_MTS = 7U,
	TEGRA_ARI_MCA_RD_BANK_INFO = 0x0fU,
	TEGRA_ARI_MCA_RD_BANK_TEMPLATE = 0x10U,
	TEGRA_ARI_MCA_RD_WR_SECURE_ACCESS_REGISTER = 0x11U,
	TEGRA_ARI_MCA_RD_WR_GLOBAL_CONFIG_REGISTER = 0x12U,
} tegra_ari_mca_rd_wr_indexes_t;

typedef enum {
	TEGRA_ARI_MCA_RD_WR_ASERRX_CTRL = 0U,
	TEGRA_ARI_MCA_RD_WR_ASERRX_STATUS = 1U,
	TEGRA_ARI_MCA_RD_WR_ASERRX_ADDR = 2U,
	TEGRA_ARI_MCA_RD_WR_ASERRX_MISC1 = 3U,
	TEGRA_ARI_MCA_RD_WR_ASERRX_MISC2 = 4U,
} tegra_ari_mca_read_asserx_subindexes_t;

typedef enum {
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_SECURE_REGISTER_SETTING_ENABLES_NS_PERMITTED, 0U, 0U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_SECURE_REGISTER_READING_STATUS_NS_PERMITTED, 1U, 1U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_SECURE_REGISTER_PENDING_MCA_ERRORS_NS_PERMITTED, 2U, 2U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_SECURE_REGISTER_CLEARING_MCA_INTERRUPTS_NS_PERMITTED, 3U, 3U),
} tegra_ari_mca_secure_register_bitmasks_t;

typedef enum {
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR0_STAT_SERR_ERR_CODE, 0U, 15U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR0_STAT_PWM_ERR, 16U, 16U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR0_STAT_CRAB_ERR, 17U, 17U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR0_STAT_RD_WR_N, 18U, 18U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR0_STAT_UCODE_ERR, 19U, 19U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR0_STAT_PWM, 20U, 23U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR0_STAT_AV, 58U, 58U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR0_STAT_MV, 59U, 59U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR0_STAT_EN, 60U, 60U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR0_STAT_UC, 61U, 61U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR0_STAT_OVF, 62U, 62U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR0_STAT_VAL, 63U, 63U),

	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR0_ADDR_ADDR, 0U, 41U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR0_ADDR_UCODE_ERRCD, 42U, 52U),

	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR0_CTRL_EN_PWM_ERR, 0U, 0U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR0_CTRL_EN_CRAB_ERR, 1U, 1U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR0_CTRL_EN_UCODE_ERR, 3U, 3U),
} tegra_ari_mca_aserr0_bitmasks_t;

typedef enum {
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR1_STAT_SERR_ERR_CODE, 0U, 15U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR1_STAT_MSI_ERR, 16U, 16U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR1_STAT_IHI_ERR, 17U, 17U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR1_STAT_CRI_ERR, 18U, 18U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR1_STAT_MMCRAB_ERR, 19U, 19U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR1_STAT_CSI_ERR, 20U, 20U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR1_STAT_RD_WR_N, 21U, 21U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR1_STAT_REQ_ERRT, 22U, 23U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR1_STAT_RESP_ERRT, 24U, 25U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR1_STAT_AV, 58U, 58U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR1_STAT_MV, 59U, 59U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR1_STAT_EN, 60U, 60U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR1_STAT_UC, 61U, 61U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR1_STAT_OVF, 62U, 62U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR1_STAT_VAL, 63U, 63U),

	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR1_STAT_AXI_ID, 0U, 7U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR1_STAT_CQX_ID, 8U, 27U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR1_STAT_CQX_CID, 28U, 31U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR1_STAT_CQX_CMD, 32U, 35U),

	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR1_CTRL_EN_MSI_ERR, 0U, 0U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR1_CTRL_EN_IHI_ERR, 1U, 1U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR1_CTRL_EN_CRI_ERR, 2U, 2U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR1_CTRL_EN_MMCRAB_ERR, 3U, 3U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR1_CTRL_EN_CSI_ERR, 4U, 4U),

	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR1_MISC_ADDR, 0U, 41U),
} tegra_ari_mca_aserr1_bitmasks_t;

typedef enum {
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR2_STAT_SERR_ERR_CODE, 0U, 15U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR2_STAT_MC_ERR, 16U, 16U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR2_STAT_SYSRAM_ERR, 17U, 17U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR2_STAT_CLIENT_ID, 18U, 19U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR2_STAT_AV, 58U, 58U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR2_STAT_MV, 59U, 59U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR2_STAT_EN, 60U, 60U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR2_STAT_UC, 61U, 61U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR2_STAT_OVF, 62U, 62U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR2_STAT_VAL, 63U, 63U),

	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR2_ADDR_ID, 0U, 17U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR2_ADDR_CMD, 18U, 21U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR2_ADDR_ADDR, 22U, 53U),

	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR2_CTRL_EN_MC_ERR, 0U, 0U),
} tegra_ari_mca_aserr2_bitmasks_t;

typedef enum {
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR3_STAT_SERR_ERR_CODE, 0U, 15U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR3_STAT_TO_ERR, 16U, 16U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR3_STAT_STAT_ERR, 17U, 17U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR3_STAT_DST_ERR, 18U, 18U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR3_STAT_UNC_ERR, 19U, 19U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR3_STAT_MH_ERR, 20U, 20U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR3_STAT_PERR, 21U, 21U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR3_STAT_PSN_ERR, 22U, 22U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR3_STAT_AV, 58U, 58U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR3_STAT_MV, 59U, 59U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR3_STAT_EN, 60U, 60U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR3_STAT_UC, 61U, 61U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR3_STAT_OVF, 62U, 62U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR3_STAT_VAL, 63U, 63U),

	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR3_ADDR_CMD, 0U, 5U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR3_ADDR_ADDR, 6U, 47U),

	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR3_MISC1_TO, 0U, 0U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR3_MISC1_DIV4, 1U, 1U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR3_MISC1_TLIMIT, 2U, 11U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR3_MISC1_PSN_ERR_CORR_MSK, 12U, 25U),

	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR3_MISC2_MORE_INFO, 0U, 17U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR3_MISC2_TO_INFO, 18U, 43U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR3_MISC2_SRC, 44U, 45U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR3_MISC2_TID, 46U, 52U),

	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR3_CTRL_EN_TO_ERR, 0U, 0U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR3_CTRL_EN_STAT_ERR, 1U, 1U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR3_CTRL_EN_DST_ERR, 2U, 2U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR3_CTRL_EN_UNC_ERR, 3U, 3U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR3_CTRL_EN_MH_ERR, 4U, 4U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR3_CTRL_EN_PERR, 5U, 5U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR3_CTRL_EN_PSN_ERR, 6U, 19U),
} tegra_ari_mca_aserr3_bitmasks_t;

typedef enum {
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR4_STAT_SERR_ERR_CODE, 0U, 15U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR4_STAT_SRC_ERR, 16U, 16U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR4_STAT_DST_ERR, 17U, 17U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR4_STAT_REQ_ERR, 18U, 18U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR4_STAT_RSP_ERR, 19U, 19U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR4_STAT_AV, 58U, 58U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR4_STAT_MV, 59U, 59U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR4_STAT_EN, 60U, 60U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR4_STAT_UC, 61U, 61U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR4_STAT_OVF, 62U, 62U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR4_STAT_VAL, 63U, 63U),

	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR4_CTRL_EN_CPE_ERR, 0U, 0U),
} tegra_ari_mca_aserr4_bitmasks_t;

typedef enum {
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR5_STAT_SERR_ERR_CODE, 0U, 15U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR5_STAT_CTUPAR, 16U, 16U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR5_STAT_MULTI, 17U, 17U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR5_STAT_AV, 58U, 58U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR5_STAT_MV, 59U, 59U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR5_STAT_EN, 60U, 60U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR5_STAT_UC, 61U, 61U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR5_STAT_OVF, 62U, 62U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR5_STAT_VAL, 63U, 63U),

	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR5_ADDR_SRC, 0U, 7U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR5_ADDR_ID, 8U, 15U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR5_ADDR_DATA, 16U, 26U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR5_ADDR_CMD, 32U, 35U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR5_ADDR_ADDR, 36U, 45U),

	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_ASERR5_CTRL_EN_CTUPAR, 0U, 0U),
} tegra_ari_mca_aserr5_bitmasks_t;

typedef enum {
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_SERR1_STAT_SERR_ERR_CODE, 0U, 15U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_SERR1_STAT_AV, 58U, 58U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_SERR1_STAT_MV, 59U, 59U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_SERR1_STAT_EN, 60U, 60U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_SERR1_STAT_UC, 61U, 61U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_SERR1_STAT_OVF, 62U, 62U),
	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_SERR1_STAT_VAL, 63U, 63U),

	TEGRA_ARI_ENUM_MASK_LSB_MSB(TEGRA_ARI_MCA_SERR1_ADDR_TBD_INFO, 0U, 63U),
} tegra_ari_mca_serr1_bitmasks_t;

#undef TEGRA_ARI_ENUM_MASK_LSB_MSB

typedef enum {
	TEGRA_NVG_CHANNEL_PMIC = 0U,
	TEGRA_NVG_CHANNEL_POWER_PERF = 1U,
	TEGRA_NVG_CHANNEL_POWER_MODES = 2U,
	TEGRA_NVG_CHANNEL_WAKE_TIME = 3U,
	TEGRA_NVG_CHANNEL_CSTATE_INFO = 4U,
	TEGRA_NVG_CHANNEL_CROSSOVER_C1_C6 = 5U,
	TEGRA_NVG_CHANNEL_CROSSOVER_CC1_CC6 = 6U,
	TEGRA_NVG_CHANNEL_CROSSOVER_CC1_CC7 = 7U,
	TEGRA_NVG_CHANNEL_CROSSOVER_CCP1_CCP3 = 8U,  /* obsoleted */
	TEGRA_NVG_CHANNEL_CROSSOVER_CCP3_SC2 = 9U,  /* obsoleted */
	TEGRA_NVG_CHANNEL_CROSSOVER_CCP3_SC3 = 10U,  /* obsoleted */
	TEGRA_NVG_CHANNEL_CROSSOVER_CCP3_SC4 = 11U,  /* obsoleted */
	TEGRA_NVG_CHANNEL_CROSSOVER_CCP3_SC7 = 12U,  /* obsoleted */
	TEGRA_NVG_CHANNEL_CROSSOVER_SC0_SC7 = 12U,
	TEGRA_NVG_CHANNEL_CSTATE_STATS_CLEAR = 13U,
	TEGRA_NVG_CHANNEL_CSTATE_STATS_SC7_ENTRIES = 14U,
	TEGRA_NVG_CHANNEL_CSTATE_STATS_SC4_ENTRIES = 15U,  /* obsoleted */
	TEGRA_NVG_CHANNEL_CSTATE_STATS_SC3_ENTRIES = 16U,  /* obsoleted */
	TEGRA_NVG_CHANNEL_CSTATE_STATS_SC2_ENTRIES = 17U,  /* obsoleted */
	TEGRA_NVG_CHANNEL_CSTATE_STATS_CCP3_ENTRIES = 18U,  /* obsoleted */
	TEGRA_NVG_CHANNEL_CSTATE_STATS_A57_CC6_ENTRIES = 19U,
	TEGRA_NVG_CHANNEL_CSTATE_STATS_A57_CC7_ENTRIES = 20U,
	TEGRA_NVG_CHANNEL_CSTATE_STATS_D15_CC6_ENTRIES = 21U,
	TEGRA_NVG_CHANNEL_CSTATE_STATS_D15_CC7_ENTRIES = 22U,
	TEGRA_NVG_CHANNEL_CSTATE_STATS_D15_0_C6_ENTRIES = 23U,
	TEGRA_NVG_CHANNEL_CSTATE_STATS_D15_1_C6_ENTRIES = 24U,
	TEGRA_NVG_CHANNEL_CSTATE_STATS_D15_2_C6_ENTRIES = 25U, /* Reserved (for Denver15 core 2) */
	TEGRA_NVG_CHANNEL_CSTATE_STATS_D15_3_C6_ENTRIES = 26U, /* Reserved (for Denver15 core 3) */
	TEGRA_NVG_CHANNEL_CSTATE_STATS_D15_0_C7_ENTRIES = 27U,
	TEGRA_NVG_CHANNEL_CSTATE_STATS_D15_1_C7_ENTRIES = 28U,
	TEGRA_NVG_CHANNEL_CSTATE_STATS_D15_2_C7_ENTRIES = 29U, /* Reserved (for Denver15 core 2) */
	TEGRA_NVG_CHANNEL_CSTATE_STATS_D15_3_C7_ENTRIES = 30U, /*  Reserved (for Denver15 core 3) */
	TEGRA_NVG_CHANNEL_CSTATE_STATS_A57_0_C7_ENTRIES = 31U,
	TEGRA_NVG_CHANNEL_CSTATE_STATS_A57_1_C7_ENTRIES = 32U,
	TEGRA_NVG_CHANNEL_CSTATE_STATS_A57_2_C7_ENTRIES = 33U,
	TEGRA_NVG_CHANNEL_CSTATE_STATS_A57_3_C7_ENTRIES = 34U,
	TEGRA_NVG_CHANNEL_CSTATE_STATS_LAST_CSTATE_ENTRY_D15_0 = 35U,
	TEGRA_NVG_CHANNEL_CSTATE_STATS_LAST_CSTATE_ENTRY_D15_1 = 36U,
	TEGRA_NVG_CHANNEL_CSTATE_STATS_LAST_CSTATE_ENTRY_D15_2 = 37U, /* Reserved (for Denver15 core 2) */
	TEGRA_NVG_CHANNEL_CSTATE_STATS_LAST_CSTATE_ENTRY_D15_3 = 38U, /*  Reserved (for Denver15 core 3) */
	TEGRA_NVG_CHANNEL_CSTATE_STATS_LAST_CSTATE_ENTRY_A57_0 = 39U,
	TEGRA_NVG_CHANNEL_CSTATE_STATS_LAST_CSTATE_ENTRY_A57_1 = 40U,
	TEGRA_NVG_CHANNEL_CSTATE_STATS_LAST_CSTATE_ENTRY_A57_2 = 41U,
	TEGRA_NVG_CHANNEL_CSTATE_STATS_LAST_CSTATE_ENTRY_A57_3 = 42U,
	TEGRA_NVG_CHANNEL_IS_SC7_ALLOWED = 43U,
	TEGRA_NVG_CHANNEL_ONLINE_CORE = 44U,
	TEGRA_NVG_CHANNEL_CC3_CTRL = 45U,
	TEGRA_NVG_CHANNEL_CROSSOVER_CCP3_SC1 = 46U,  /* obsoleted */
	TEGRA_NVG_CHANNEL_LAST_INDEX,
} tegra_nvg_channel_id_t;

#endif /* T18X_TEGRA_ARI_H */
