/*
 * Copyright (c) 2015-2019, ARM Limited and Contributors. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef TBBR_IMG_DEF_H
#define TBBR_IMG_DEF_H

#include <export/common/tbbr/tbbr_img_def_exp.h>

#if defined(SPD_spmd)
#define SP_CONTENT_CERT_ID		MAX_IMAGE_IDS
#define SP_PKG1_ID			(MAX_IMAGE_IDS + 1)
#define SP_PKG2_ID			(MAX_IMAGE_IDS + 2)
#define SP_PKG3_ID			(MAX_IMAGE_IDS + 3)
#define SP_PKG4_ID			(MAX_IMAGE_IDS + 4)
#define SP_PKG5_ID			(MAX_IMAGE_IDS + 5)
#define SP_PKG6_ID			(MAX_IMAGE_IDS + 6)
#define SP_PKG7_ID			(MAX_IMAGE_IDS + 7)
#define SP_PKG8_ID			(MAX_IMAGE_IDS + 8)
#define MAX_SP_IDS			U(8)
#define MAX_NUMBER_IDS			(MAX_IMAGE_IDS + MAX_SP_IDS + U(1))
#else
#define MAX_NUMBER_IDS			MAX_IMAGE_IDS
#endif

#endif /* TBBR_IMG_DEF_H */
