/*
 * Copyright (C) 2018 Marvell International Ltd.
 *
 * SPDX-License-Identifier:     BSD-3-Clause
 * https://spdx.org/licenses
 */

/* Driver for COMPHY unit that is part or Marvell A8K SoCs */

#ifndef _COMPHY_H_
#define _COMPHY_H_

/* COMPHY registers */
#define COMMON_PHY_CFG1_REG			0x0
#define COMMON_PHY_CFG1_PWR_UP_OFFSET		1
#define COMMON_PHY_CFG1_PWR_UP_MASK		\
				(0x1 << COMMON_PHY_CFG1_PWR_UP_OFFSET)
#define COMMON_PHY_CFG1_PIPE_SELECT_OFFSET	2
#define COMMON_PHY_CFG1_PIPE_SELECT_MASK	\
				(0x1 << COMMON_PHY_CFG1_PIPE_SELECT_OFFSET)
#define COMMON_PHY_CFG1_PWR_ON_RESET_OFFSET	13
#define COMMON_PHY_CFG1_PWR_ON_RESET_MASK	\
				(0x1 << COMMON_PHY_CFG1_PWR_ON_RESET_OFFSET)
#define COMMON_PHY_CFG1_CORE_RSTN_OFFSET	14
#define COMMON_PHY_CFG1_CORE_RSTN_MASK		\
				(0x1 << COMMON_PHY_CFG1_CORE_RSTN_OFFSET)
#define COMMON_PHY_PHY_MODE_OFFSET		15
#define COMMON_PHY_PHY_MODE_MASK		\
				(0x1 << COMMON_PHY_PHY_MODE_OFFSET)

#define COMMON_SELECTOR_PHY_OFFSET			0x140
#define COMMON_SELECTOR_PIPE_OFFSET			0x144

#define COMMON_PHY_SD_CTRL1				0x148
#define COMMON_PHY_SD_CTRL1_COMPHY_0_4_PORT_OFFSET	0
#define COMMON_PHY_SD_CTRL1_COMPHY_0_4_PORT_MASK	0xFFFF
#define COMMON_PHY_SD_CTRL1_PCIE_X4_EN_OFFSET		24
#define COMMON_PHY_SD_CTRL1_PCIE_X4_EN_MASK		\
				(0x1 << COMMON_PHY_SD_CTRL1_PCIE_X4_EN_OFFSET)
#define COMMON_PHY_SD_CTRL1_PCIE_X2_EN_OFFSET		25
#define COMMON_PHY_SD_CTRL1_PCIE_X2_EN_MASK		\
				(0x1 << COMMON_PHY_SD_CTRL1_PCIE_X2_EN_OFFSET)

#define DFX_DEV_GEN_CTRL12			0x80
#define DFX_DEV_GEN_PCIE_CLK_SRC_OFFSET		7
#define DFX_DEV_GEN_PCIE_CLK_SRC_MASK		\
				(0x3 << DFX_DEV_GEN_PCIE_CLK_SRC_OFFSET)

/* HPIPE register */
#define HPIPE_PWR_PLL_REG			0x4
#define HPIPE_PWR_PLL_REF_FREQ_OFFSET		0
#define HPIPE_PWR_PLL_REF_FREQ_MASK		\
				(0x1f << HPIPE_PWR_PLL_REF_FREQ_OFFSET)
#define HPIPE_PWR_PLL_PHY_MODE_OFFSET		5
#define HPIPE_PWR_PLL_PHY_MODE_MASK		\
				(0x7 << HPIPE_PWR_PLL_PHY_MODE_OFFSET)

#define HPIPE_DFE_REG0				0x01C
#define HPIPE_DFE_RES_FORCE_OFFSET		15
#define HPIPE_DFE_RES_FORCE_MASK		\
				(0x1 << HPIPE_DFE_RES_FORCE_OFFSET)

#define HPIPE_G2_SET_1_REG			0x040
#define HPIPE_G2_SET_1_G2_RX_SELMUPI_OFFSET	0
#define HPIPE_G2_SET_1_G2_RX_SELMUPI_MASK	\
				(0x7 << HPIPE_G2_SET_1_G2_RX_SELMUPI_OFFSET)
#define HPIPE_G2_SET_1_G2_RX_SELMUPP_OFFSET	3
#define HPIPE_G2_SET_1_G2_RX_SELMUPP_MASK	\
				(0x7 << HPIPE_G2_SET_1_G2_RX_SELMUPP_OFFSET)
#define HPIPE_G2_SET_1_G2_RX_SELMUFI_OFFSET	6
#define HPIPE_G2_SET_1_G2_RX_SELMUFI_MASK	\
				(0x3 << HPIPE_G2_SET_1_G2_RX_SELMUFI_OFFSET)

#define HPIPE_G3_SETTINGS_1_REG			0x048
#define HPIPE_G3_RX_SELMUPI_OFFSET		0
#define HPIPE_G3_RX_SELMUPI_MASK		\
				(0x7 << HPIPE_G3_RX_SELMUPI_OFFSET)
#define HPIPE_G3_RX_SELMUPF_OFFSET		3
#define HPIPE_G3_RX_SELMUPF_MASK		\
				(0x7 << HPIPE_G3_RX_SELMUPF_OFFSET)
#define HPIPE_G3_SETTING_BIT_OFFSET		13
#define HPIPE_G3_SETTING_BIT_MASK		\
				(0x1 << HPIPE_G3_SETTING_BIT_OFFSET)

#define HPIPE_INTERFACE_REG			0x94
#define HPIPE_INTERFACE_GEN_MAX_OFFSET		10
#define HPIPE_INTERFACE_GEN_MAX_MASK		\
				(0x3 << HPIPE_INTERFACE_GEN_MAX_OFFSET)
#define HPIPE_INTERFACE_DET_BYPASS_OFFSET	12
#define HPIPE_INTERFACE_DET_BYPASS_MASK		\
				(0x1 << HPIPE_INTERFACE_DET_BYPASS_OFFSET)
#define HPIPE_INTERFACE_LINK_TRAIN_OFFSET	14
#define HPIPE_INTERFACE_LINK_TRAIN_MASK		\
				(0x1 << HPIPE_INTERFACE_LINK_TRAIN_OFFSET)

#define HPIPE_VDD_CAL_CTRL_REG			0x114
#define HPIPE_EXT_SELLV_RXSAMPL_OFFSET		5
#define HPIPE_EXT_SELLV_RXSAMPL_MASK		\
				(0x1f << HPIPE_EXT_SELLV_RXSAMPL_OFFSET)

#define HPIPE_PCIE_REG0				0x120
#define HPIPE_PCIE_IDLE_SYNC_OFFSET		12
#define HPIPE_PCIE_IDLE_SYNC_MASK		\
				(0x1 << HPIPE_PCIE_IDLE_SYNC_OFFSET)
#define HPIPE_PCIE_SEL_BITS_OFFSET		13
#define HPIPE_PCIE_SEL_BITS_MASK		\
				(0x3 << HPIPE_PCIE_SEL_BITS_OFFSET)

#define HPIPE_LANE_ALIGN_REG			0x124
#define HPIPE_LANE_ALIGN_OFF_OFFSET		12
#define HPIPE_LANE_ALIGN_OFF_MASK		\
				(0x1 << HPIPE_LANE_ALIGN_OFF_OFFSET)

#define HPIPE_MISC_REG				0x13C
#define HPIPE_MISC_CLK100M_125M_OFFSET		4
#define HPIPE_MISC_CLK100M_125M_MASK		\
				(0x1 << HPIPE_MISC_CLK100M_125M_OFFSET)
#define HPIPE_MISC_ICP_FORCE_OFFSET		5
#define HPIPE_MISC_ICP_FORCE_MASK		\
				(0x1 << HPIPE_MISC_ICP_FORCE_OFFSET)
#define HPIPE_MISC_TXDCLK_2X_OFFSET		6
#define HPIPE_MISC_TXDCLK_2X_MASK		\
				(0x1 << HPIPE_MISC_TXDCLK_2X_OFFSET)
#define HPIPE_MISC_CLK500_EN_OFFSET		7
#define HPIPE_MISC_CLK500_EN_MASK		\
				(0x1 << HPIPE_MISC_CLK500_EN_OFFSET)
#define HPIPE_MISC_REFCLK_SEL_OFFSET		10
#define HPIPE_MISC_REFCLK_SEL_MASK		\
				(0x1 << HPIPE_MISC_REFCLK_SEL_OFFSET)

#define HPIPE_SAMPLER_N_PROC_CALIB_CTRL_REG	0x16C
#define HPIPE_SMAPLER_OFFSET			12
#define HPIPE_SMAPLER_MASK			(0x1 << HPIPE_SMAPLER_OFFSET)

#define HPIPE_PWR_CTR_DTL_REG			0x184
#define HPIPE_PWR_CTR_DTL_FLOOP_EN_OFFSET	2
#define HPIPE_PWR_CTR_DTL_FLOOP_EN_MASK		\
				(0x1 << HPIPE_PWR_CTR_DTL_FLOOP_EN_OFFSET)

#define HPIPE_FRAME_DET_CONTROL_REG		0x220
#define HPIPE_FRAME_DET_LOCK_LOST_TO_OFFSET	12
#define HPIPE_FRAME_DET_LOCK_LOST_TO_MASK	\
				(0x1 << HPIPE_FRAME_DET_LOCK_LOST_TO_OFFSET)

#define HPIPE_TX_TRAIN_CTRL_0_REG		0x268
#define HPIPE_TX_TRAIN_P2P_HOLD_OFFSET		15
#define HPIPE_TX_TRAIN_P2P_HOLD_MASK		\
				(0x1 << HPIPE_TX_TRAIN_P2P_HOLD_OFFSET)

#define HPIPE_TX_TRAIN_CTRL_REG			0x26C
#define HPIPE_TX_TRAIN_CTRL_G1_OFFSET		0
#define HPIPE_TX_TRAIN_CTRL_G1_MASK		\
				(0x1 << HPIPE_TX_TRAIN_CTRL_G1_OFFSET)
#define HPIPE_TX_TRAIN_CTRL_GN1_OFFSET		1
#define HPIPE_TX_TRAIN_CTRL_GN1_MASK		\
				(0x1 << HPIPE_TX_TRAIN_CTRL_GN1_OFFSET)
#define HPIPE_TX_TRAIN_CTRL_G0_OFFSET		2
#define HPIPE_TX_TRAIN_CTRL_G0_MASK		\
				(0x1 << HPIPE_TX_TRAIN_CTRL_G0_OFFSET)

#define HPIPE_TX_TRAIN_CTRL_4_REG		0x278
#define HPIPE_TRX_TRAIN_TIMER_OFFSET		0
#define HPIPE_TRX_TRAIN_TIMER_MASK		\
				(0x3FF << HPIPE_TRX_TRAIN_TIMER_OFFSET)

#define HPIPE_TX_TRAIN_CTRL_5_REG		0x2A4
#define HPIPE_TX_TRAIN_START_SQ_EN_OFFSET	11
#define HPIPE_TX_TRAIN_START_SQ_EN_MASK		\
				(0x1 << HPIPE_TX_TRAIN_START_SQ_EN_OFFSET)
#define HPIPE_TX_TRAIN_START_FRM_DET_EN_OFFSET	12
#define HPIPE_TX_TRAIN_START_FRM_DET_EN_MASK	\
				(0x1 << HPIPE_TX_TRAIN_START_FRM_DET_EN_OFFSET)
#define HPIPE_TX_TRAIN_START_FRM_LOCK_EN_OFFSET	13
#define HPIPE_TX_TRAIN_START_FRM_LOCK_EN_MASK	\
				(0x1 << HPIPE_TX_TRAIN_START_FRM_LOCK_EN_OFFSET)
#define HPIPE_TX_TRAIN_WAIT_TIME_EN_OFFSET	14
#define HPIPE_TX_TRAIN_WAIT_TIME_EN_MASK	\
				(0x1 << HPIPE_TX_TRAIN_WAIT_TIME_EN_OFFSET)

#define HPIPE_TX_TRAIN_REG			0x31C
#define HPIPE_TX_TRAIN_CHK_INIT_OFFSET		4
#define HPIPE_TX_TRAIN_CHK_INIT_MASK		\
				(0x1 << HPIPE_TX_TRAIN_CHK_INIT_OFFSET)
#define HPIPE_TX_TRAIN_COE_FM_PIN_PCIE3_OFFSET	7
#define HPIPE_TX_TRAIN_COE_FM_PIN_PCIE3_MASK	\
				(0x1 << HPIPE_TX_TRAIN_COE_FM_PIN_PCIE3_OFFSET)

#define HPIPE_CDR_CONTROL_REG			0x418
#define HPIPE_CDR_RX_MAX_DFE_ADAPT_0_OFFSET	14
#define HPIPE_CDR_RX_MAX_DFE_ADAPT_0_MASK	\
				(0x3 << HPIPE_CDR_RX_MAX_DFE_ADAPT_0_OFFSET)
#define HPIPE_CDR_RX_MAX_DFE_ADAPT_1_OFFSET	12
#define HPIPE_CDR_RX_MAX_DFE_ADAPT_1_MASK	\
				(0x3 << HPIPE_CDR_RX_MAX_DFE_ADAPT_1_OFFSET)
#define HPIPE_CDR_MAX_DFE_ADAPT_0_OFFSET	9
#define HPIPE_CDR_MAX_DFE_ADAPT_0_MASK		\
				(0x7 << HPIPE_CDR_MAX_DFE_ADAPT_0_OFFSET)
#define HPIPE_CDR_MAX_DFE_ADAPT_1_OFFSET	6
#define HPIPE_CDR_MAX_DFE_ADAPT_1_MASK		\
				(0x7 << HPIPE_CDR_MAX_DFE_ADAPT_1_OFFSET)

#define HPIPE_TX_TRAIN_CTRL_11_REG		0x438
#define HPIPE_TX_STATUS_CHECK_MODE_OFFSET	6
#define HPIPE_TX_TX_STATUS_CHECK_MODE_MASK	\
				(0x1 << HPIPE_TX_STATUS_CHECK_MODE_OFFSET)
#define HPIPE_TX_NUM_OF_PRESET_OFFSET		10
#define HPIPE_TX_NUM_OF_PRESET_MASK		\
				(0x7 << HPIPE_TX_NUM_OF_PRESET_OFFSET)
#define HPIPE_TX_SWEEP_PRESET_EN_OFFSET		15
#define HPIPE_TX_SWEEP_PRESET_EN_MASK		\
				(0x1 << HPIPE_TX_SWEEP_PRESET_EN_OFFSET)
#define HPIPE_G2_SETTINGS_4_REG			0x44C
#define HPIPE_G2_DFE_RES_OFFSET			8
#define HPIPE_G2_DFE_RES_MASK			(0x3 << HPIPE_G2_DFE_RES_OFFSET)

#define HPIPE_G3_SETTING_3_REG			0x450
#define HPIPE_G3_FFE_CAP_SEL_OFFSET		0
#define HPIPE_G3_FFE_CAP_SEL_MASK		\
				(0xf << HPIPE_G3_FFE_CAP_SEL_OFFSET)
#define HPIPE_G3_FFE_RES_SEL_OFFSET		4
#define HPIPE_G3_FFE_RES_SEL_MASK		\
				(0x7 << HPIPE_G3_FFE_RES_SEL_OFFSET)
#define HPIPE_G3_FFE_SETTING_FORCE_OFFSET	7
#define HPIPE_G3_FFE_SETTING_FORCE_MASK		\
				(0x1 << HPIPE_G3_FFE_SETTING_FORCE_OFFSET)
#define HPIPE_G3_FFE_DEG_RES_LEVEL_OFFSET	12
#define HPIPE_G3_FFE_DEG_RES_LEVEL_MASK		\
				(0x3 << HPIPE_G3_FFE_DEG_RES_LEVEL_OFFSET)
#define HPIPE_G3_FFE_LOAD_RES_LEVEL_OFFSET	14
#define HPIPE_G3_FFE_LOAD_RES_LEVEL_MASK	\
				(0x3 << HPIPE_G3_FFE_LOAD_RES_LEVEL_OFFSET)

#define HPIPE_G3_SETTING_4_REG			0x454
#define HPIPE_G3_DFE_RES_OFFSET			8
#define HPIPE_G3_DFE_RES_MASK			(0x3 << HPIPE_G3_DFE_RES_OFFSET)

#define HPIPE_DFE_CONTROL_REG			0x470
#define HPIPE_DFE_TX_MAX_DFE_ADAPT_OFFSET	14
#define HPIPE_DFE_TX_MAX_DFE_ADAPT_MASK		\
				(0x3 << HPIPE_DFE_TX_MAX_DFE_ADAPT_OFFSET)

#define HPIPE_DFE_CTRL_28_REG			0x49C
#define HPIPE_DFE_CTRL_28_PIPE4_OFFSET		7
#define HPIPE_DFE_CTRL_28_PIPE4_MASK		\
				(0x1 << HPIPE_DFE_CTRL_28_PIPE4_OFFSET)

#define HPIPE_G3_SETTING_5_REG			0x548
#define HPIPE_G3_SETTING_5_G3_ICP_OFFSET	0
#define HPIPE_G3_SETTING_5_G3_ICP_MASK		\
				(0xf << HPIPE_G3_SETTING_5_G3_ICP_OFFSET)

#define HPIPE_LANE_STATUS1_REG			0x60C
#define HPIPE_LANE_STATUS1_PCLK_EN_OFFSET	0
#define HPIPE_LANE_STATUS1_PCLK_EN_MASK		\
				(0x1 << HPIPE_LANE_STATUS1_PCLK_EN_OFFSET)

#define HPIPE_LANE_CFG4_REG			0x620
#define HPIPE_LANE_CFG4_DFE_EN_SEL_OFFSET	3
#define HPIPE_LANE_CFG4_DFE_EN_SEL_MASK		\
				(0x1 << HPIPE_LANE_CFG4_DFE_EN_SEL_OFFSET)

#define HPIPE_LANE_EQU_CONFIG_0_REG		0x69C
#define HPIPE_CFG_EQ_FS_OFFSET			0
#define HPIPE_CFG_EQ_FS_MASK			(0x3f << HPIPE_CFG_EQ_FS_OFFSET)
#define HPIPE_CFG_EQ_LF_OFFSET			6
#define HPIPE_CFG_EQ_LF_MASK			(0x3f << HPIPE_CFG_EQ_LF_OFFSET)
#define HPIPE_CFG_PHY_RC_EP_OFFSET		12
#define HPIPE_CFG_PHY_RC_EP_MASK		\
				(0x1 << HPIPE_CFG_PHY_RC_EP_OFFSET)

#define HPIPE_LANE_EQ_CFG1_REG			0x6a0
#define HPIPE_CFG_UPDATE_POLARITY_OFFSET	12
#define HPIPE_CFG_UPDATE_POLARITY_MASK		\
				(0x1 << HPIPE_CFG_UPDATE_POLARITY_OFFSET)

#define HPIPE_LANE_EQ_CFG2_REG			0x6a4
#define HPIPE_CFG_EQ_BUNDLE_DIS_OFFSET		14
#define HPIPE_CFG_EQ_BUNDLE_DIS_MASK		\
				(0x1 << HPIPE_CFG_EQ_BUNDLE_DIS_OFFSET)

#define HPIPE_LANE_PRESET_CFG0_REG		0x6a8
#define HPIPE_CFG_CURSOR_PRESET0_OFFSET		0
#define HPIPE_CFG_CURSOR_PRESET0_MASK		\
				(0x3f << HPIPE_CFG_CURSOR_PRESET0_OFFSET)
#define HPIPE_CFG_CURSOR_PRESET1_OFFSET		6
#define HPIPE_CFG_CURSOR_PRESET1_MASK		\
				(0x3f << HPIPE_CFG_CURSOR_PRESET1_OFFSET)

#define HPIPE_LANE_PRESET_CFG1_REG		0x6ac
#define HPIPE_CFG_CURSOR_PRESET2_OFFSET		0
#define HPIPE_CFG_CURSOR_PRESET2_MASK		\
				(0x3f << HPIPE_CFG_CURSOR_PRESET2_OFFSET)
#define HPIPE_CFG_CURSOR_PRESET3_OFFSET		6
#define HPIPE_CFG_CURSOR_PRESET3_MASK		\
				(0x3f << HPIPE_CFG_CURSOR_PRESET3_OFFSET)

#define HPIPE_LANE_PRESET_CFG2_REG		0x6b0
#define HPIPE_CFG_CURSOR_PRESET4_OFFSET		0
#define HPIPE_CFG_CURSOR_PRESET4_MASK		\
				(0x3f << HPIPE_CFG_CURSOR_PRESET4_OFFSET)
#define HPIPE_CFG_CURSOR_PRESET5_OFFSET		6
#define HPIPE_CFG_CURSOR_PRESET5_MASK		\
				(0x3f << HPIPE_CFG_CURSOR_PRESET5_OFFSET)

#define HPIPE_LANE_PRESET_CFG3_REG		0x6b4
#define HPIPE_CFG_CURSOR_PRESET6_OFFSET		0
#define HPIPE_CFG_CURSOR_PRESET6_MASK		\
				(0x3f << HPIPE_CFG_CURSOR_PRESET6_OFFSET)
#define HPIPE_CFG_CURSOR_PRESET7_OFFSET		6
#define HPIPE_CFG_CURSOR_PRESET7_MASK		\
				(0x3f << HPIPE_CFG_CURSOR_PRESET7_OFFSET)

#define HPIPE_LANE_PRESET_CFG4_REG		0x6b8
#define HPIPE_CFG_CURSOR_PRESET8_OFFSET		0
#define HPIPE_CFG_CURSOR_PRESET8_MASK		\
				(0x3f << HPIPE_CFG_CURSOR_PRESET8_OFFSET)
#define HPIPE_CFG_CURSOR_PRESET9_OFFSET		6
#define HPIPE_CFG_CURSOR_PRESET9_MASK		\
				(0x3f << HPIPE_CFG_CURSOR_PRESET9_OFFSET)

#define HPIPE_LANE_PRESET_CFG5_REG		0x6bc
#define HPIPE_CFG_CURSOR_PRESET10_OFFSET	0
#define HPIPE_CFG_CURSOR_PRESET10_MASK		\
				(0x3f << HPIPE_CFG_CURSOR_PRESET10_OFFSET)
#define HPIPE_CFG_CURSOR_PRESET11_OFFSET	6
#define HPIPE_CFG_CURSOR_PRESET11_MASK		\
				(0x3f << HPIPE_CFG_CURSOR_PRESET11_OFFSET)

#define HPIPE_LANE_PRESET_CFG6_REG		0x6c0
#define HPIPE_CFG_PRE_CURSOR_PRESET0_OFFSET	0
#define HPIPE_CFG_PRE_CURSOR_PRESET0_MASK	\
				(0x3f << HPIPE_CFG_PRE_CURSOR_PRESET0_OFFSET)
#define HPIPE_CFG_POST_CURSOR_PRESET0_OFFSET	6
#define HPIPE_CFG_POST_CURSOR_PRESET0_MASK	\
				(0x3f << HPIPE_CFG_POST_CURSOR_PRESET0_OFFSET)

#define HPIPE_LANE_PRESET_CFG7_REG		0x6c4
#define HPIPE_CFG_PRE_CURSOR_PRESET1_OFFSET	0
#define HPIPE_CFG_PRE_CURSOR_PRESET1_MASK	\
				(0x3f << HPIPE_CFG_PRE_CURSOR_PRESET1_OFFSET)
#define HPIPE_CFG_POST_CURSOR_PRESET1_OFFSET	6
#define HPIPE_CFG_POST_CURSOR_PRESET1_MASK	\
				(0x3f << HPIPE_CFG_POST_CURSOR_PRESET1_OFFSET)

#define HPIPE_LANE_PRESET_CFG8_REG		0x6c8
#define HPIPE_CFG_PRE_CURSOR_PRESET2_OFFSET	0
#define HPIPE_CFG_PRE_CURSOR_PRESET2_MASK	\
				(0x3f << HPIPE_CFG_PRE_CURSOR_PRESET2_OFFSET)
#define HPIPE_CFG_POST_CURSOR_PRESET2_OFFSET	6
#define HPIPE_CFG_POST_CURSOR_PRESET2_MASK	\
				(0x3f << HPIPE_CFG_POST_CURSOR_PRESET2_OFFSET)

#define HPIPE_LANE_PRESET_CFG9_REG		0x6cc
#define HPIPE_CFG_PRE_CURSOR_PRESET3_OFFSET	0
#define HPIPE_CFG_PRE_CURSOR_PRESET3_MASK	\
				(0x3f << HPIPE_CFG_PRE_CURSOR_PRESET3_OFFSET)
#define HPIPE_CFG_POST_CURSOR_PRESET3_OFFSET	6
#define HPIPE_CFG_POST_CURSOR_PRESET3_MASK	\
				(0x3f << HPIPE_CFG_POST_CURSOR_PRESET3_OFFSET)

#define HPIPE_LANE_PRESET_CFG10_REG		0x6d0
#define HPIPE_CFG_PRE_CURSOR_PRESET4_OFFSET	0
#define HPIPE_CFG_PRE_CURSOR_PRESET4_MASK	\
				(0x3f << HPIPE_CFG_PRE_CURSOR_PRESET4_OFFSET)
#define HPIPE_CFG_POST_CURSOR_PRESET4_OFFSET	6
#define HPIPE_CFG_POST_CURSOR_PRESET4_MASK	\
				(0x3f << HPIPE_CFG_POST_CURSOR_PRESET4_OFFSET)

#define HPIPE_LANE_PRESET_CFG11_REG		0x6d4
#define HPIPE_CFG_PRE_CURSOR_PRESET5_OFFSET	0
#define HPIPE_CFG_PRE_CURSOR_PRESET5_MASK	\
				(0x3f << HPIPE_CFG_PRE_CURSOR_PRESET5_OFFSET)
#define HPIPE_CFG_POST_CURSOR_PRESET5_OFFSET	6
#define HPIPE_CFG_POST_CURSOR_PRESET5_MASK	\
				(0x3f << HPIPE_CFG_POST_CURSOR_PRESET5_OFFSET)

#define HPIPE_LANE_PRESET_CFG12_REG		0x6d8
#define HPIPE_CFG_PRE_CURSOR_PRESET6_OFFSET	0
#define HPIPE_CFG_PRE_CURSOR_PRESET6_MASK	\
				(0x3f << HPIPE_CFG_PRE_CURSOR_PRESET6_OFFSET)
#define HPIPE_CFG_POST_CURSOR_PRESET6_OFFSET	6
#define HPIPE_CFG_POST_CURSOR_PRESET6_MASK	\
				(0x3f << HPIPE_CFG_POST_CURSOR_PRESET6_OFFSET)

#define HPIPE_LANE_PRESET_CFG13_REG		0x6dc
#define HPIPE_CFG_PRE_CURSOR_PRESET7_OFFSET	0
#define HPIPE_CFG_PRE_CURSOR_PRESET7_MASK	\
				(0x3f << HPIPE_CFG_PRE_CURSOR_PRESET7_OFFSET)
#define HPIPE_CFG_POST_CURSOR_PRESET7_OFFSET	6
#define HPIPE_CFG_POST_CURSOR_PRESET7_MASK	\
				(0x3f << HPIPE_CFG_POST_CURSOR_PRESET7_OFFSET)

#define HPIPE_LANE_PRESET_CFG14_REG		0x6e0
#define HPIPE_CFG_PRE_CURSOR_PRESET8_OFFSET	0
#define HPIPE_CFG_PRE_CURSOR_PRESET8_MASK	\
				(0x3f << HPIPE_CFG_PRE_CURSOR_PRESET8_OFFSET)
#define HPIPE_CFG_POST_CURSOR_PRESET8_OFFSET	6
#define HPIPE_CFG_POST_CURSOR_PRESET8_MASK	\
				(0x3f << HPIPE_CFG_POST_CURSOR_PRESET8_OFFSET)

#define HPIPE_LANE_PRESET_CFG15_REG		0x6e4
#define HPIPE_CFG_PRE_CURSOR_PRESET9_OFFSET	0
#define HPIPE_CFG_PRE_CURSOR_PRESET9_MASK	\
				(0x3f << HPIPE_CFG_PRE_CURSOR_PRESET9_OFFSET)
#define HPIPE_CFG_POST_CURSOR_PRESET9_OFFSET	6
#define HPIPE_CFG_POST_CURSOR_PRESET9_MASK	\
				(0x3f << HPIPE_CFG_POST_CURSOR_PRESET9_OFFSET)

#define HPIPE_LANE_PRESET_CFG16_REG		0x6e8
#define HPIPE_CFG_PRE_CURSOR_PRESET10_OFFSET	0
#define HPIPE_CFG_PRE_CURSOR_PRESET10_MASK	\
				(0x3f << HPIPE_CFG_PRE_CURSOR_PRESET10_OFFSET)
#define HPIPE_CFG_POST_CURSOR_PRESET10_OFFSET	6
#define HPIPE_CFG_POST_CURSOR_PRESET10_MASK	\
				(0x3f << HPIPE_CFG_POST_CURSOR_PRESET10_OFFSET)

#define HPIPE_LANE_EQ_REMOTE_SETTING_REG	0x6f8
#define HPIPE_LANE_CFG_FOM_DIRN_OVERRIDE_OFFSET	0
#define HPIPE_LANE_CFG_FOM_DIRN_OVERRIDE_MASK	\
				(0x1 << HPIPE_LANE_CFG_FOM_DIRN_OVERRIDE_OFFSET)
#define HPIPE_LANE_CFG_FOM_ONLY_MODE_OFFFSET	1
#define HPIPE_LANE_CFG_FOM_ONLY_MODE_MASK	\
				(0x1 << HPIPE_LANE_CFG_FOM_ONLY_MODE_OFFFSET)
#define HPIPE_LANE_CFG_FOM_PRESET_VECTOR_OFFSET	2
#define HPIPE_LANE_CFG_FOM_PRESET_VECTOR_MASK	\
				(0xf << HPIPE_LANE_CFG_FOM_PRESET_VECTOR_OFFSET)

#define HPIPE_RST_CLK_CTRL_REG			0x704
#define HPIPE_RST_CLK_CTRL_PIPE_RST_OFFSET	0
#define HPIPE_RST_CLK_CTRL_PIPE_RST_MASK	\
				(0x1 << HPIPE_RST_CLK_CTRL_PIPE_RST_OFFSET)
#define HPIPE_RST_CLK_CTRL_FIXED_PCLK_OFFSET	2
#define HPIPE_RST_CLK_CTRL_FIXED_PCLK_MASK	\
				(0x1 << HPIPE_RST_CLK_CTRL_FIXED_PCLK_OFFSET)
#define HPIPE_RST_CLK_CTRL_PIPE_WIDTH_OFFSET	3
#define HPIPE_RST_CLK_CTRL_PIPE_WIDTH_MASK	\
				(0x1 << HPIPE_RST_CLK_CTRL_PIPE_WIDTH_OFFSET)
#define HPIPE_RST_CLK_CTRL_CORE_FREQ_SEL_OFFSET	9
#define HPIPE_RST_CLK_CTRL_CORE_FREQ_SEL_MASK	\
				(0x1 << HPIPE_RST_CLK_CTRL_CORE_FREQ_SEL_OFFSET)

#define HPIPE_CLK_SRC_LO_REG				0x70c
#define HPIPE_CLK_SRC_LO_BUNDLE_PERIOD_SEL_OFFSET	1
#define HPIPE_CLK_SRC_LO_BUNDLE_PERIOD_SEL_MASK		\
			(0x1 << HPIPE_CLK_SRC_LO_BUNDLE_PERIOD_SEL_OFFSET)
#define HPIPE_CLK_SRC_LO_BUNDLE_PERIOD_SCALE_OFFSET	2
#define HPIPE_CLK_SRC_LO_BUNDLE_PERIOD_SCALE_MASK	\
			(0x3 << HPIPE_CLK_SRC_LO_BUNDLE_PERIOD_SCALE_OFFSET)
#define HPIPE_CLK_SRC_LO_PLL_RDY_DL_OFFSET		5
#define HPIPE_CLK_SRC_LO_PLL_RDY_DL_MASK		\
			(0x7 << HPIPE_CLK_SRC_LO_PLL_RDY_DL_OFFSET)

#define HPIPE_CLK_SRC_HI_REG			0x710
#define HPIPE_CLK_SRC_HI_LANE_STRT_OFFSET	0
#define HPIPE_CLK_SRC_HI_LANE_STRT_MASK		\
			(0x1 << HPIPE_CLK_SRC_HI_LANE_STRT_OFFSET)
#define HPIPE_CLK_SRC_HI_LANE_BREAK_OFFSET	1
#define HPIPE_CLK_SRC_HI_LANE_BREAK_MASK	\
			(0x1 << HPIPE_CLK_SRC_HI_LANE_BREAK_OFFSET)
#define HPIPE_CLK_SRC_HI_LANE_MASTER_OFFSET	2
#define HPIPE_CLK_SRC_HI_LANE_MASTER_MASK	\
			(0x1 << HPIPE_CLK_SRC_HI_LANE_MASTER_OFFSET)
#define HPIPE_CLK_SRC_HI_MODE_PIPE_OFFSET	7
#define HPIPE_CLK_SRC_HI_MODE_PIPE_MASK		\
			(0x1 << HPIPE_CLK_SRC_HI_MODE_PIPE_OFFSET)

#define HPIPE_GLOBAL_PM_CTRL			0x740
#define HPIPE_GLOBAL_PM_RXDLOZ_WAIT_OFFSET	0
#define HPIPE_GLOBAL_PM_RXDLOZ_WAIT_MASK	\
			(0xFF << HPIPE_GLOBAL_PM_RXDLOZ_WAIT_OFFSET)

#endif /* _COMPHY_H_ */

