/*
 * Copyright (c) 2015-2019, STMicroelectronics - All Rights Reserved
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef STM32_GPIO_H
#define STM32_GPIO_H

#include <lib/utils_def.h>

#define GPIO_MODE_OFFSET	U(0x00)
#define GPIO_TYPE_OFFSET	U(0x04)
#define GPIO_SPEED_OFFSET	U(0x08)
#define GPIO_PUPD_OFFSET	U(0x0C)
#define GPIO_BSRR_OFFSET	U(0x18)
#define GPIO_AFRL_OFFSET	U(0x20)
#define GPIO_AFRH_OFFSET	U(0x24)
#define GPIO_SECR_OFFSET	U(0x30)

#define GPIO_ALT_LOWER_LIMIT	U(0x08)

#define GPIO_PIN_(_x)		U(_x)
#define GPIO_PIN_MAX		GPIO_PIN_(15)

#define GPIO_ALTERNATE_(_x)	U(_x)
#define GPIO_ALTERNATE_MASK	U(0x0F)

#define GPIO_MODE_INPUT		0x00
#define GPIO_MODE_OUTPUT	0x01
#define GPIO_MODE_ALTERNATE	0x02
#define GPIO_MODE_ANALOG	0x03
#define GPIO_MODE_MASK		U(0x03)

#define GPIO_OPEN_DRAIN		U(0x10)

#define GPIO_SPEED_LOW		0x00
#define GPIO_SPEED_MEDIUM	0x01
#define GPIO_SPEED_HIGH		0x02
#define GPIO_SPEED_VERY_HIGH	0x03
#define GPIO_SPEED_MASK		U(0x03)

#define GPIO_NO_PULL		0x00
#define GPIO_PULL_UP		0x01
#define GPIO_PULL_DOWN		0x02
#define GPIO_PULL_MASK		U(0x03)

#ifndef __ASSEMBLER__
#include <stdint.h>

int dt_set_pinctrl_config(int node);
void set_gpio(uint32_t bank, uint32_t pin, uint32_t mode, uint32_t speed,
	      uint32_t pull, uint32_t alternate, uint8_t status);
void set_gpio_secure_cfg(uint32_t bank, uint32_t pin, bool secure);
#endif /*__ASSEMBLER__*/

#endif /* STM32_GPIO_H */
