/*
 * Copyright (c) 2020, ARM Limited and Contributors. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
#ifndef PLAT_MACROS_S
#define PLAT_MACROS_S

#include <platform_def.h>

.section .rodata.gic_reg_name, "aS"
gicc_regs:
	.asciz "gicc_hppir", "gicc_ahppir", "gicc_ctlr", ""
gicd_pend_reg:
	.asciz "gicd_ispendr regs (Offsets 0x200 - 0x278)\n"	\
		" Offset:\t\t\tvalue\n"
newline:
	.asciz "\n"
spacer:
	.asciz ":\t\t0x"

.section .rodata.cci_reg_name, "aS"
cci_iface_regs:
	.asciz "cci_snoop_ctrl_cluster0", "cci_snoop_ctrl_cluster1" , ""

	/* ---------------------------------------------
	 * The below macro prints out relevant GIC and
	 * CCI registers whenever an unhandled exception
	 * is taken in BL31.
	 * Clobbers: x0 - x10, x26, x27, sp
	 * ---------------------------------------------
	 */
	.macro plat_crash_print_regs
	/* To-do: GIC owner */
	/* To-do: CCI owner */
	.endm

#endif /* PLAT_MACROS_S */
