/*
 * Copyright (c) 2020U, Renesas Electronics Corporation. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef RZG_INIT_DRAM_TABLE_G2M_H
#define RZG_INIT_DRAM_TABLE_G2M_H

#define DDR_PHY_SLICE_REGSET_OFS_G2M  0x0800U
#define DDR_PHY_ADR_V_REGSET_OFS_G2M  0x0a00U
#define DDR_PHY_ADR_I_REGSET_OFS_G2M  0x0a80U
#define DDR_PHY_ADR_G_REGSET_OFS_G2M  0x0b80U
#define DDR_PI_REGSET_OFS_G2M         0x0200U

#define DDR_PHY_SLICE_REGSET_SIZE_G2M 0x80U
#define DDR_PHY_ADR_V_REGSET_SIZE_G2M 0x80U
#define DDR_PHY_ADR_I_REGSET_SIZE_G2M 0x80U
#define DDR_PHY_ADR_G_REGSET_SIZE_G2M 0x80U
#define DDR_PI_REGSET_SIZE_G2M        0x100U

#define DDR_PHY_SLICE_REGSET_NUM_G2M  89
#define DDR_PHY_ADR_V_REGSET_NUM_G2M  37
#define DDR_PHY_ADR_I_REGSET_NUM_G2M  37
#define DDR_PHY_ADR_G_REGSET_NUM_G2M  64
#define DDR_PI_REGSET_NUM_G2M         202

static const uint32_t DDR_PHY_SLICE_REGSET_G2M[DDR_PHY_SLICE_REGSET_NUM_G2M] = {
	/*0800*/ 0x76543210U,
	/*0801*/ 0x0004f008U,
	/*0802*/ 0x00000000U,
	/*0803*/ 0x00000000U,
	/*0804*/ 0x00010000U,
	/*0805*/ 0x036e6e0eU,
	/*0806*/ 0x026e6e0eU,
	/*0807*/ 0x00010300U,
	/*0808*/ 0x04000100U,
	/*0809*/ 0x00000300U,
	/*080a*/ 0x001700c0U,
	/*080b*/ 0x00b00201U,
	/*080c*/ 0x00030020U,
	/*080d*/ 0x00000000U,
	/*080e*/ 0x00000000U,
	/*080f*/ 0x00000000U,
	/*0810*/ 0x00000000U,
	/*0811*/ 0x00000000U,
	/*0812*/ 0x00000000U,
	/*0813*/ 0x00000000U,
	/*0814*/ 0x09000000U,
	/*0815*/ 0x04080000U,
	/*0816*/ 0x04080400U,
	/*0817*/ 0x00000000U,
	/*0818*/ 0x32103210U,
	/*0819*/ 0x00800708U,
	/*081a*/ 0x000f000cU,
	/*081b*/ 0x00000100U,
	/*081c*/ 0x55aa55aaU,
	/*081d*/ 0x33cc33ccU,
	/*081e*/ 0x0ff00ff0U,
	/*081f*/ 0x0f0ff0f0U,
	/*0820*/ 0x00018e38U,
	/*0821*/ 0x00000000U,
	/*0822*/ 0x00000000U,
	/*0823*/ 0x00000000U,
	/*0824*/ 0x00000000U,
	/*0825*/ 0x00000000U,
	/*0826*/ 0x00000000U,
	/*0827*/ 0x00000000U,
	/*0828*/ 0x00000000U,
	/*0829*/ 0x00000000U,
	/*082a*/ 0x00000000U,
	/*082b*/ 0x00000000U,
	/*082c*/ 0x00000000U,
	/*082d*/ 0x00000000U,
	/*082e*/ 0x00000000U,
	/*082f*/ 0x00000000U,
	/*0830*/ 0x00000000U,
	/*0831*/ 0x00000000U,
	/*0832*/ 0x00000000U,
	/*0833*/ 0x00200000U,
	/*0834*/ 0x08200820U,
	/*0835*/ 0x08200820U,
	/*0836*/ 0x08200820U,
	/*0837*/ 0x08200820U,
	/*0838*/ 0x08200820U,
	/*0839*/ 0x00000820U,
	/*083a*/ 0x03000300U,
	/*083b*/ 0x03000300U,
	/*083c*/ 0x03000300U,
	/*083d*/ 0x03000300U,
	/*083e*/ 0x00000300U,
	/*083f*/ 0x00000000U,
	/*0840*/ 0x00000000U,
	/*0841*/ 0x00000000U,
	/*0842*/ 0x00000000U,
	/*0843*/ 0x00a00000U,
	/*0844*/ 0x00a000a0U,
	/*0845*/ 0x00a000a0U,
	/*0846*/ 0x00a000a0U,
	/*0847*/ 0x00a000a0U,
	/*0848*/ 0x00a000a0U,
	/*0849*/ 0x00a000a0U,
	/*084a*/ 0x00a000a0U,
	/*084b*/ 0x00a000a0U,
	/*084c*/ 0x010900a0U,
	/*084d*/ 0x02000104U,
	/*084e*/ 0x00000000U,
	/*084f*/ 0x00010000U,
	/*0850*/ 0x00000200U,
	/*0851*/ 0x4041a151U,
	/*0852*/ 0xc00141a0U,
	/*0853*/ 0x0e0100c0U,
	/*0854*/ 0x0010000cU,
	/*0855*/ 0x0c064208U,
	/*0856*/ 0x000f0c18U,
	/*0857*/ 0x00e00140U,
	/*0858*/ 0x00000c20U
};

static const uint32_t DDR_PHY_ADR_V_REGSET_G2M[DDR_PHY_ADR_V_REGSET_NUM_G2M] = {
	/*0a00*/ 0x00000000U,
	/*0a01*/ 0x00000000U,
	/*0a02*/ 0x00000000U,
	/*0a03*/ 0x00000000U,
	/*0a04*/ 0x00000000U,
	/*0a05*/ 0x00000000U,
	/*0a06*/ 0x00000002U,
	/*0a07*/ 0x00000000U,
	/*0a08*/ 0x00000000U,
	/*0a09*/ 0x00000000U,
	/*0a0a*/ 0x00400320U,
	/*0a0b*/ 0x00000040U,
	/*0a0c*/ 0x00dcba98U,
	/*0a0d*/ 0x00000000U,
	/*0a0e*/ 0x00dcba98U,
	/*0a0f*/ 0x01000000U,
	/*0a10*/ 0x00020003U,
	/*0a11*/ 0x00000000U,
	/*0a12*/ 0x00000000U,
	/*0a13*/ 0x00000000U,
	/*0a14*/ 0x0000002aU,
	/*0a15*/ 0x00000015U,
	/*0a16*/ 0x00000015U,
	/*0a17*/ 0x0000002aU,
	/*0a18*/ 0x00000033U,
	/*0a19*/ 0x0000000cU,
	/*0a1a*/ 0x0000000cU,
	/*0a1b*/ 0x00000033U,
	/*0a1c*/ 0x0a418820U,
	/*0a1d*/ 0x003f0000U,
	/*0a1e*/ 0x0000003fU,
	/*0a1f*/ 0x0002c06eU,
	/*0a20*/ 0x02c002c0U,
	/*0a21*/ 0x02c002c0U,
	/*0a22*/ 0x000002c0U,
	/*0a23*/ 0x42080010U,
	/*0a24*/ 0x00000003U
};

static const uint32_t DDR_PHY_ADR_I_REGSET_G2M[DDR_PHY_ADR_I_REGSET_NUM_G2M] = {
	/*0a80*/ 0x04040404U,
	/*0a81*/ 0x00000404U,
	/*0a82*/ 0x00000000U,
	/*0a83*/ 0x00000000U,
	/*0a84*/ 0x00000000U,
	/*0a85*/ 0x00000000U,
	/*0a86*/ 0x00000002U,
	/*0a87*/ 0x00000000U,
	/*0a88*/ 0x00000000U,
	/*0a89*/ 0x00000000U,
	/*0a8a*/ 0x00400320U,
	/*0a8b*/ 0x00000040U,
	/*0a8c*/ 0x00000000U,
	/*0a8d*/ 0x00000000U,
	/*0a8e*/ 0x00000000U,
	/*0a8f*/ 0x01000000U,
	/*0a90*/ 0x00020003U,
	/*0a91*/ 0x00000000U,
	/*0a92*/ 0x00000000U,
	/*0a93*/ 0x00000000U,
	/*0a94*/ 0x0000002aU,
	/*0a95*/ 0x00000015U,
	/*0a96*/ 0x00000015U,
	/*0a97*/ 0x0000002aU,
	/*0a98*/ 0x00000033U,
	/*0a99*/ 0x0000000cU,
	/*0a9a*/ 0x0000000cU,
	/*0a9b*/ 0x00000033U,
	/*0a9c*/ 0x00000000U,
	/*0a9d*/ 0x00000000U,
	/*0a9e*/ 0x00000000U,
	/*0a9f*/ 0x0002c06eU,
	/*0aa0*/ 0x02c002c0U,
	/*0aa1*/ 0x02c002c0U,
	/*0aa2*/ 0x000002c0U,
	/*0aa3*/ 0x42080010U,
	/*0aa4*/ 0x00000003U
};

static const uint32_t DDR_PHY_ADR_G_REGSET_G2M[DDR_PHY_ADR_G_REGSET_NUM_G2M] = {
	/*0b80*/ 0x00000001U,
	/*0b81*/ 0x00000000U,
	/*0b82*/ 0x00000005U,
	/*0b83*/ 0x04000f00U,
	/*0b84*/ 0x00020080U,
	/*0b85*/ 0x00020055U,
	/*0b86*/ 0x00000000U,
	/*0b87*/ 0x00000000U,
	/*0b88*/ 0x00000000U,
	/*0b89*/ 0x00000050U,
	/*0b8a*/ 0x00000000U,
	/*0b8b*/ 0x01010100U,
	/*0b8c*/ 0x00000600U,
	/*0b8d*/ 0x50640000U,
	/*0b8e*/ 0x01421142U,
	/*0b8f*/ 0x00000142U,
	/*0b90*/ 0x00000000U,
	/*0b91*/ 0x000f1600U,
	/*0b92*/ 0x0f160f16U,
	/*0b93*/ 0x0f160f16U,
	/*0b94*/ 0x00000003U,
	/*0b95*/ 0x0002c000U,
	/*0b96*/ 0x02c002c0U,
	/*0b97*/ 0x000002c0U,
	/*0b98*/ 0x03421342U,
	/*0b99*/ 0x00000342U,
	/*0b9a*/ 0x00000000U,
	/*0b9b*/ 0x00000000U,
	/*0b9c*/ 0x05020000U,
	/*0b9d*/ 0x00000000U,
	/*0b9e*/ 0x00027f6eU,
	/*0b9f*/ 0x047f027fU,
	/*0ba0*/ 0x00027f6eU,
	/*0ba1*/ 0x00047f6eU,
	/*0ba2*/ 0x0003554fU,
	/*0ba3*/ 0x0001554fU,
	/*0ba4*/ 0x0001554fU,
	/*0ba5*/ 0x0001554fU,
	/*0ba6*/ 0x0001554fU,
	/*0ba7*/ 0x00003feeU,
	/*0ba8*/ 0x0001554fU,
	/*0ba9*/ 0x00003feeU,
	/*0baa*/ 0x0001554fU,
	/*0bab*/ 0x00027f6eU,
	/*0bac*/ 0x0001554fU,
	/*0bad*/ 0x00000000U,
	/*0bae*/ 0x00000000U,
	/*0baf*/ 0x00000000U,
	/*0bb0*/ 0x65000000U,
	/*0bb1*/ 0x00000000U,
	/*0bb2*/ 0x00000000U,
	/*0bb3*/ 0x00000201U,
	/*0bb4*/ 0x00000000U,
	/*0bb5*/ 0x00000000U,
	/*0bb6*/ 0x00000000U,
	/*0bb7*/ 0x00000000U,
	/*0bb8*/ 0x00000000U,
	/*0bb9*/ 0x00000000U,
	/*0bba*/ 0x00000000U,
	/*0bbb*/ 0x00000000U,
	/*0bbc*/ 0x06e40000U,
	/*0bbd*/ 0x00000000U,
	/*0bbe*/ 0x00000000U,
	/*0bbf*/ 0x00010000U
};

static const uint32_t DDR_PI_REGSET_G2M[DDR_PI_REGSET_NUM_G2M] = {
	/*0200*/ 0x00000b00U,
	/*0201*/ 0x00000100U,
	/*0202*/ 0x00000000U,
	/*0203*/ 0x0000ffffU,
	/*0204*/ 0x00000000U,
	/*0205*/ 0x0000ffffU,
	/*0206*/ 0x00000000U,
	/*0207*/ 0x304cffffU,
	/*0208*/ 0x00000200U,
	/*0209*/ 0x00000200U,
	/*020a*/ 0x00000200U,
	/*020b*/ 0x00000200U,
	/*020c*/ 0x0000304cU,
	/*020d*/ 0x00000200U,
	/*020e*/ 0x00000200U,
	/*020f*/ 0x00000200U,
	/*0210*/ 0x00000200U,
	/*0211*/ 0x0000304cU,
	/*0212*/ 0x00000200U,
	/*0213*/ 0x00000200U,
	/*0214*/ 0x00000200U,
	/*0215*/ 0x00000200U,
	/*0216*/ 0x00010000U,
	/*0217*/ 0x00000003U,
	/*0218*/ 0x01000001U,
	/*0219*/ 0x00000000U,
	/*021a*/ 0x00000000U,
	/*021b*/ 0x00000000U,
	/*021c*/ 0x00000000U,
	/*021d*/ 0x00000000U,
	/*021e*/ 0x00000000U,
	/*021f*/ 0x00000000U,
	/*0220*/ 0x00000000U,
	/*0221*/ 0x00000000U,
	/*0222*/ 0x00000000U,
	/*0223*/ 0x00000000U,
	/*0224*/ 0x00000000U,
	/*0225*/ 0x00000000U,
	/*0226*/ 0x00000000U,
	/*0227*/ 0x00000000U,
	/*0228*/ 0x00000000U,
	/*0229*/ 0x0f000101U,
	/*022a*/ 0x08492d25U,
	/*022b*/ 0x0e0c0004U,
	/*022c*/ 0x000e5000U,
	/*022d*/ 0x00000250U,
	/*022e*/ 0x00460003U,
	/*022f*/ 0x182600cfU,
	/*0230*/ 0x182600cfU,
	/*0231*/ 0x00000005U,
	/*0232*/ 0x00000000U,
	/*0233*/ 0x00000000U,
	/*0234*/ 0x00000000U,
	/*0235*/ 0x00000000U,
	/*0236*/ 0x00000000U,
	/*0237*/ 0x00000000U,
	/*0238*/ 0x00000000U,
	/*0239*/ 0x01000000U,
	/*023a*/ 0x00040404U,
	/*023b*/ 0x01280a00U,
	/*023c*/ 0x00000000U,
	/*023d*/ 0x000f0000U,
	/*023e*/ 0x00001803U,
	/*023f*/ 0x00000000U,
	/*0240*/ 0x00000000U,
	/*0241*/ 0x00060002U,
	/*0242*/ 0x00010001U,
	/*0243*/ 0x01000101U,
	/*0244*/ 0x04020201U,
	/*0245*/ 0x00080804U,
	/*0246*/ 0x00000000U,
	/*0247*/ 0x08030000U,
	/*0248*/ 0x15150408U,
	/*0249*/ 0x00000000U,
	/*024a*/ 0x00000000U,
	/*024b*/ 0x00000000U,
	/*024c*/ 0x000f0f00U,
	/*024d*/ 0x0000001eU,
	/*024e*/ 0x00000000U,
	/*024f*/ 0x01000300U,
	/*0250*/ 0x00000000U,
	/*0251*/ 0x00000000U,
	/*0252*/ 0x01000000U,
	/*0253*/ 0x00010101U,
	/*0254*/ 0x000e0e0eU,
	/*0255*/ 0x000c0c0cU,
	/*0256*/ 0x02060601U,
	/*0257*/ 0x00000000U,
	/*0258*/ 0x00000003U,
	/*0259*/ 0x00181703U,
	/*025a*/ 0x00280006U,
	/*025b*/ 0x00280016U,
	/*025c*/ 0x00000016U,
	/*025d*/ 0x00000000U,
	/*025e*/ 0x00000000U,
	/*025f*/ 0x00000000U,
	/*0260*/ 0x140a0000U,
	/*0261*/ 0x0005010aU,
	/*0262*/ 0x03018d03U,
	/*0263*/ 0x000a018dU,
	/*0264*/ 0x00060100U,
	/*0265*/ 0x01000006U,
	/*0266*/ 0x018e018eU,
	/*0267*/ 0x018e0100U,
	/*0268*/ 0x1111018eU,
	/*0269*/ 0x10010204U,
	/*026a*/ 0x09090650U,
	/*026b*/ 0x20110202U,
	/*026c*/ 0x00201000U,
	/*026d*/ 0x00201000U,
	/*026e*/ 0x04041000U,
	/*026f*/ 0x18020100U,
	/*0270*/ 0x00010118U,
	/*0271*/ 0x004b004aU,
	/*0272*/ 0x050f0000U,
	/*0273*/ 0x0c01021eU,
	/*0274*/ 0x34000000U,
	/*0275*/ 0x00000000U,
	/*0276*/ 0x00000000U,
	/*0277*/ 0x00000000U,
	/*0278*/ 0x0000d400U,
	/*0279*/ 0x0031002eU,
	/*027a*/ 0x00111136U,
	/*027b*/ 0x002e00d4U,
	/*027c*/ 0x11360031U,
	/*027d*/ 0x0000d411U,
	/*027e*/ 0x0031002eU,
	/*027f*/ 0x00111136U,
	/*0280*/ 0x002e00d4U,
	/*0281*/ 0x11360031U,
	/*0282*/ 0x0000d411U,
	/*0283*/ 0x0031002eU,
	/*0284*/ 0x00111136U,
	/*0285*/ 0x002e00d4U,
	/*0286*/ 0x11360031U,
	/*0287*/ 0x00d40011U,
	/*0288*/ 0x0031002eU,
	/*0289*/ 0x00111136U,
	/*028a*/ 0x002e00d4U,
	/*028b*/ 0x11360031U,
	/*028c*/ 0x0000d411U,
	/*028d*/ 0x0031002eU,
	/*028e*/ 0x00111136U,
	/*028f*/ 0x002e00d4U,
	/*0290*/ 0x11360031U,
	/*0291*/ 0x0000d411U,
	/*0292*/ 0x0031002eU,
	/*0293*/ 0x00111136U,
	/*0294*/ 0x002e00d4U,
	/*0295*/ 0x11360031U,
	/*0296*/ 0x02000011U,
	/*0297*/ 0x018d018dU,
	/*0298*/ 0x0c08018dU,
	/*0299*/ 0x1f121d22U,
	/*029a*/ 0x4301b344U,
	/*029b*/ 0x10172006U,
	/*029c*/ 0x1d220c10U,
	/*029d*/ 0x00001f12U,
	/*029e*/ 0x4301b344U,
	/*029f*/ 0x10172006U,
	/*02a0*/ 0x1d220c10U,
	/*02a1*/ 0x00001f12U,
	/*02a2*/ 0x4301b344U,
	/*02a3*/ 0x10172006U,
	/*02a4*/ 0x02000210U,
	/*02a5*/ 0x02000200U,
	/*02a6*/ 0x02000200U,
	/*02a7*/ 0x02000200U,
	/*02a8*/ 0x02000200U,
	/*02a9*/ 0x00000000U,
	/*02aa*/ 0x00000000U,
	/*02ab*/ 0x00000000U,
	/*02ac*/ 0x00000000U,
	/*02ad*/ 0x00000000U,
	/*02ae*/ 0x00000000U,
	/*02af*/ 0x00000000U,
	/*02b0*/ 0x00000000U,
	/*02b1*/ 0x00000000U,
	/*02b2*/ 0x00000000U,
	/*02b3*/ 0x00000000U,
	/*02b4*/ 0x00000000U,
	/*02b5*/ 0x00000400U,
	/*02b6*/ 0x15141312U,
	/*02b7*/ 0x11100f0eU,
	/*02b8*/ 0x080b0c0dU,
	/*02b9*/ 0x05040a09U,
	/*02ba*/ 0x01000706U,
	/*02bb*/ 0x00000302U,
	/*02bc*/ 0x01030201U,
	/*02bd*/ 0x00304c00U,
	/*02be*/ 0x0001e2f8U,
	/*02bf*/ 0x0000304cU,
	/*02c0*/ 0x0001e2f8U,
	/*02c1*/ 0x0000304cU,
	/*02c2*/ 0x0001e2f8U,
	/*02c3*/ 0x08000000U,
	/*02c4*/ 0x00000100U,
	/*02c5*/ 0x00000000U,
	/*02c6*/ 0x00000000U,
	/*02c7*/ 0x00000000U,
	/*02c8*/ 0x00000000U,
	/*02c9*/ 0x00000002U
};

#endif /* RZG_INIT_DRAM_TABLE_G2M_H */
