ARM Trusted Firmware for QEMU virt ARMv8-A
==========================================

ARM Trusted Firmware implements the EL3 firmware layer for QEMU virt
ARMv8-A.  BL1 is used as the BootROM, supplied with the -bios argument.
When QEMU starts all CPUs are released simultaneously, BL1 selects a
primary CPU to handle the boot and the secondaries are placed in a polling
loop to be released by normal world via PSCI.

BL2 edits the Flattened Device Tree, FDT, generated by QEMU at run-time to
add a node describing PSCI and also enable methods for the CPUs.

An ARM64 defonfig v4.5 Linux kernel is known to boot, FTD doesn't need to be
provided as it's generated by QEMU.

Current limitations:
* Only cold boot is supported
* No build instructions for QEMU_EFI.fd and rootfs-arm64.cpio.gz
* No instructions for how to load a BL32 (Secure Payload)

`QEMU_EFI.fd` can be dowloaded from
http://snapshots.linaro.org/components/kernel/leg-virt-tianocore-edk2-upstream/latest/QEMU-KERNEL-AARCH64/RELEASE_GCC49/QEMU_EFI.fd

Boot binaries, except BL1, are primarily loaded via semi-hosting so all
binaries has to reside in the same directory as QEMU is started from.  This
is conveniently achieved with symlinks the local names as:
* `bl2.bin` -> BL2
* `bl31.bin` -> BL31
* `bl33.bin` -> BL33 (`QEMU_EFI.fd`)
* `Image` -> linux/Image

To build:
```
make CROSS_COMPILE=aarch64-none-elf- PLAT=qemu 
```

To start (QEMU v2.6.0):
```
qemu-system-aarch64 -nographic -machine virt,secure=on -cpu cortex-a57	\
	-kernel Image							\
	-append console=ttyAMA0,38400 keep_bootcon root=/dev/vda2 	\
	-initrd rootfs-arm64.cpio.gz -smp 2 -m 1024 -bios bl1.bin	\
	-d unimp -semihosting-config enable,target=native
```
