/*
 * Copyright (c) 2019, NVIDIA CORPORATION. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef __MEMCTRL_PLAT_CONFIG_H
#define __MEMCTRL_PLAT_CONFIG_H

#include <memctrl_v2.h>

/*******************************************************************************
 * StreamID to indicate no SMMU translations (requests to be steered on the
 * SMMU bypass path)
 ******************************************************************************/
#define MC_STREAM_ID_MAX			0x7F

/*******************************************************************************
 * Stream ID Override Config registers
 ******************************************************************************/
#define MC_STREAMID_OVERRIDE_CFG_PTCR		0x000
#define MC_STREAMID_OVERRIDE_CFG_HDAR		0x0A8
#define MC_STREAMID_OVERRIDE_CFG_HOST1XDMAR	0x0B0
#define MC_STREAMID_OVERRIDE_CFG_NVENCSRD	0x0E0
#define MC_STREAMID_OVERRIDE_CFG_SATAR		0x0F8
#define MC_STREAMID_OVERRIDE_CFG_MPCORER	0x138
#define MC_STREAMID_OVERRIDE_CFG_NVENCSWR	0x158
#define MC_STREAMID_OVERRIDE_CFG_HDAW		0x1A8
#define MC_STREAMID_OVERRIDE_CFG_MPCOREW	0x1C8
#define MC_STREAMID_OVERRIDE_CFG_SATAW		0x1E8
#define MC_STREAMID_OVERRIDE_CFG_ISPRA		0x220
#define MC_STREAMID_OVERRIDE_CFG_ISPFALR	0x228
#define MC_STREAMID_OVERRIDE_CFG_ISPWA		0x230
#define MC_STREAMID_OVERRIDE_CFG_ISPWB		0x238
#define MC_STREAMID_OVERRIDE_CFG_XUSB_HOSTR	0x250
#define MC_STREAMID_OVERRIDE_CFG_XUSB_HOSTW	0x258
#define MC_STREAMID_OVERRIDE_CFG_XUSB_DEVR	0x260
#define MC_STREAMID_OVERRIDE_CFG_XUSB_DEVW	0x268
#define MC_STREAMID_OVERRIDE_CFG_TSECSRD	0x2A0
#define MC_STREAMID_OVERRIDE_CFG_TSECSWR	0x2A8
#define MC_STREAMID_OVERRIDE_CFG_GPUSRD		0x2C0	/*TODO: remove it after HW team confirmation */
#define MC_STREAMID_OVERRIDE_CFG_GPUSWR		0x2C8	/*TODO: remove it after HW team confirmation */
#define MC_STREAMID_OVERRIDE_CFG_SDMMCRA	0x300
#define MC_STREAMID_OVERRIDE_CFG_SDMMCR		0x310
#define MC_STREAMID_OVERRIDE_CFG_SDMMCRAB	0x318
#define MC_STREAMID_OVERRIDE_CFG_SDMMCWA	0x320
#define MC_STREAMID_OVERRIDE_CFG_SDMMCW		0x330
#define MC_STREAMID_OVERRIDE_CFG_SDMMCWAB	0x338
#define MC_STREAMID_OVERRIDE_CFG_VICSRD		0x360
#define MC_STREAMID_OVERRIDE_CFG_VICSWR		0x368
#define MC_STREAMID_OVERRIDE_CFG_VIW		0x390
#define MC_STREAMID_OVERRIDE_CFG_NVDECSRD	0x3C0
#define MC_STREAMID_OVERRIDE_CFG_NVDECSWR	0x3C8
#define MC_STREAMID_OVERRIDE_CFG_APER		0x3D0
#define MC_STREAMID_OVERRIDE_CFG_APEW		0x3D8
#define MC_STREAMID_OVERRIDE_CFG_NVJPGSRD	0x3F0
#define MC_STREAMID_OVERRIDE_CFG_NVJPGSWR	0x3F8
#define MC_STREAMID_OVERRIDE_CFG_SESRD		0x400
#define MC_STREAMID_OVERRIDE_CFG_SESWR		0x408
#define MC_STREAMID_OVERRIDE_CFG_AXIAPR		0x410
#define MC_STREAMID_OVERRIDE_CFG_AXIAPW		0x418
#define MC_STREAMID_OVERRIDE_CFG_ETRR		0x420
#define MC_STREAMID_OVERRIDE_CFG_ETRW		0x428
#define MC_STREAMID_OVERRIDE_CFG_TSECSRDB	0x430
#define MC_STREAMID_OVERRIDE_CFG_TSECSWRB	0x438
#define MC_STREAMID_OVERRIDE_CFG_GPUSRD2	0x440	/*TODO: remove it after HW team confirmation */
#define MC_STREAMID_OVERRIDE_CFG_GPUSWR2	0x448	/*TODO: remove it after HW team confirmation */
#define MC_STREAMID_OVERRIDE_CFG_AXISR		0x460
#define MC_STREAMID_OVERRIDE_CFG_AXISW		0x468
#define MC_STREAMID_OVERRIDE_CFG_EQOSR		0x470
#define MC_STREAMID_OVERRIDE_CFG_EQOSW		0x478
#define MC_STREAMID_OVERRIDE_CFG_UFSHCR		0x480
#define MC_STREAMID_OVERRIDE_CFG_UFSHCW		0x488
#define MC_STREAMID_OVERRIDE_CFG_NVDISPLAYR	0x490
#define MC_STREAMID_OVERRIDE_CFG_BPMPR		0x498
#define MC_STREAMID_OVERRIDE_CFG_BPMPW		0x4A0
#define MC_STREAMID_OVERRIDE_CFG_BPMPDMAR	0x4A8
#define MC_STREAMID_OVERRIDE_CFG_BPMPDMAW	0x4B0
#define MC_STREAMID_OVERRIDE_CFG_AONR		0x4B8
#define MC_STREAMID_OVERRIDE_CFG_AONW		0x4C0
#define MC_STREAMID_OVERRIDE_CFG_AONDMAR	0x4C8
#define MC_STREAMID_OVERRIDE_CFG_AONDMAW	0x4D0
#define MC_STREAMID_OVERRIDE_CFG_SCER		0x4D8
#define MC_STREAMID_OVERRIDE_CFG_SCEW		0x4E0
#define MC_STREAMID_OVERRIDE_CFG_SCEDMAR	0x4E8
#define MC_STREAMID_OVERRIDE_CFG_SCEDMAW	0x4F0
#define MC_STREAMID_OVERRIDE_CFG_APEDMAR	0x4F8
#define MC_STREAMID_OVERRIDE_CFG_APEDMAW	0x500
#define MC_STREAMID_OVERRIDE_CFG_NVDISPLAYR1	0x508
#define MC_STREAMID_OVERRIDE_CFG_VICSRD1	0x510
#define MC_STREAMID_OVERRIDE_CFG_NVDECSRD1	0x518
#define MC_STREAMID_OVERRIDE_CFG_MIU0R		0x530
#define MC_STREAMID_OVERRIDE_CFG_MIU0W		0x538
#define MC_STREAMID_OVERRIDE_CFG_MIU1R		0x540
#define MC_STREAMID_OVERRIDE_CFG_MIU1W		0x548
#define MC_STREAMID_OVERRIDE_CFG_MIU2R		0x570
#define MC_STREAMID_OVERRIDE_CFG_MIU2W		0x578
#define MC_STREAMID_OVERRIDE_CFG_MIU3R		0x580
#define MC_STREAMID_OVERRIDE_CFG_MIU3W		0x588
#define MC_STREAMID_OVERRIDE_CFG_VIFALR		0x5E0
#define MC_STREAMID_OVERRIDE_CFG_VIFALW		0x5E8
#define MC_STREAMID_OVERRIDE_CFG_DLA0RDA	0x5F0
#define MC_STREAMID_OVERRIDE_CFG_DLA0FALRDB	0x5F8
#define MC_STREAMID_OVERRIDE_CFG_DLA0WRA	0x600
#define MC_STREAMID_OVERRIDE_CFG_DLA0FALWRB	0x608
#define MC_STREAMID_OVERRIDE_CFG_DLA1RDA	0x610
#define MC_STREAMID_OVERRIDE_CFG_DLA1FALRDB	0x618
#define MC_STREAMID_OVERRIDE_CFG_DLA1WRA	0x620
#define MC_STREAMID_OVERRIDE_CFG_DLA1FALWRB	0x628
#define MC_STREAMID_OVERRIDE_CFG_PVA0RDA	0x630
#define MC_STREAMID_OVERRIDE_CFG_PVA0RDB	0x638
#define MC_STREAMID_OVERRIDE_CFG_PVA0RDC	0x640
#define MC_STREAMID_OVERRIDE_CFG_PVA0WRA	0x648
#define MC_STREAMID_OVERRIDE_CFG_PVA0WRB	0x650
#define MC_STREAMID_OVERRIDE_CFG_PVA0WRC	0x658
#define MC_STREAMID_OVERRIDE_CFG_PVA1RDA	0x660
#define MC_STREAMID_OVERRIDE_CFG_PVA1RDB	0x668
#define MC_STREAMID_OVERRIDE_CFG_PVA1RDC	0x670
#define MC_STREAMID_OVERRIDE_CFG_PVA1WRA	0x678
#define MC_STREAMID_OVERRIDE_CFG_PVA1WRB	0x680
#define MC_STREAMID_OVERRIDE_CFG_PVA1WRC	0x688
#define MC_STREAMID_OVERRIDE_CFG_RCER		0x690
#define MC_STREAMID_OVERRIDE_CFG_RCEW		0x698
#define MC_STREAMID_OVERRIDE_CFG_RCEDMAR	0x6A0
#define MC_STREAMID_OVERRIDE_CFG_RCEDMAW	0x6A8
#define MC_STREAMID_OVERRIDE_CFG_NVENC1SRD	0x6B0
#define MC_STREAMID_OVERRIDE_CFG_NVENC1SWR	0x6B8
#define MC_STREAMID_OVERRIDE_CFG_PCIE0R		0x6C0
#define MC_STREAMID_OVERRIDE_CFG_PCIE0W		0x6C8
#define MC_STREAMID_OVERRIDE_CFG_PCIE1R		0x6D0
#define MC_STREAMID_OVERRIDE_CFG_PCIE1W		0x6D8
#define MC_STREAMID_OVERRIDE_CFG_PCIE2AR	0x6E0
#define MC_STREAMID_OVERRIDE_CFG_PCIE2AW	0x6E8
#define MC_STREAMID_OVERRIDE_CFG_PCIE3R		0x6F0
#define MC_STREAMID_OVERRIDE_CFG_PCIE3W		0x6F8
#define MC_STREAMID_OVERRIDE_CFG_PCIE4R		0x700
#define MC_STREAMID_OVERRIDE_CFG_PCIE4W		0x708
#define MC_STREAMID_OVERRIDE_CFG_PCIE5R		0x710
#define MC_STREAMID_OVERRIDE_CFG_PCIE5W		0x718
#define MC_STREAMID_OVERRIDE_CFG_ISPFALW	0x720
#define MC_STREAMID_OVERRIDE_CFG_DLA0RDA1	0x748
#define MC_STREAMID_OVERRIDE_CFG_DLA1RDA1	0x750
#define MC_STREAMID_OVERRIDE_CFG_PVA0RDA1	0x758
#define MC_STREAMID_OVERRIDE_CFG_PVA0RDB1	0x760
#define MC_STREAMID_OVERRIDE_CFG_PVA1RDA1	0x768
#define MC_STREAMID_OVERRIDE_CFG_PVA1RDB1	0x770
#define MC_STREAMID_OVERRIDE_CFG_PCIE5R1	0x778
#define MC_STREAMID_OVERRIDE_CFG_NVENCSRD1	0x780
#define MC_STREAMID_OVERRIDE_CFG_NVENC1SRD1	0x788
#define MC_STREAMID_OVERRIDE_CFG_ISPRA1		0x790
#define MC_STREAMID_OVERRIDE_CFG_PCIE0R1	0x798
#define MC_STREAMID_OVERRIDE_CFG_NVDEC1SRD	0x7C8
#define MC_STREAMID_OVERRIDE_CFG_NVDEC1SRD1	0x7D0
#define MC_STREAMID_OVERRIDE_CFG_NVDEC1SWR	0x7D8

/*******************************************************************************
 * Macro to calculate Security cfg register addr from StreamID Override register
 ******************************************************************************/
#define MC_STREAMID_OVERRIDE_TO_SECURITY_CFG(addr) (addr + sizeof(uint32_t))

/*******************************************************************************
 * Memory Controller transaction override config registers
 ******************************************************************************/
#define MC_TXN_OVERRIDE_CONFIG_HDAR		0x10a8
#define MC_TXN_OVERRIDE_CONFIG_BPMPW		0x14a0
#define MC_TXN_OVERRIDE_CONFIG_PTCR		0x1000
#define MC_TXN_OVERRIDE_CONFIG_NVDISPLAYR	0x1490
#define MC_TXN_OVERRIDE_CONFIG_EQOSW		0x1478
#define MC_TXN_OVERRIDE_CONFIG_NVJPGSWR		0x13f8
#define MC_TXN_OVERRIDE_CONFIG_ISPRA		0x1220
#define MC_TXN_OVERRIDE_CONFIG_VICSRD		0x1360
#define MC_TXN_OVERRIDE_CONFIG_MPCOREW		0x11c8
#define MC_TXN_OVERRIDE_CONFIG_GPUSRD		0x12c0
#define MC_TXN_OVERRIDE_CONFIG_AXISR		0x1460
#define MC_TXN_OVERRIDE_CONFIG_SCEDMAW		0x14f0
#define MC_TXN_OVERRIDE_CONFIG_SDMMCW		0x1330
#define MC_TXN_OVERRIDE_CONFIG_EQOSR		0x1470
#define MC_TXN_OVERRIDE_CONFIG_APEDMAR		0x14f8
#define MC_TXN_OVERRIDE_CONFIG_NVENCSRD		0x10e0
#define MC_TXN_OVERRIDE_CONFIG_SDMMCRAB		0x1318
#define MC_TXN_OVERRIDE_CONFIG_VICSRD1		0x1510
#define MC_TXN_OVERRIDE_CONFIG_BPMPDMAR		0x14a8
#define MC_TXN_OVERRIDE_CONFIG_VIW		0x1390
#define MC_TXN_OVERRIDE_CONFIG_AXISW		0x1468
#define MC_TXN_OVERRIDE_CONFIG_XUSB_DEVR	0x1260
#define MC_TXN_OVERRIDE_CONFIG_UFSHCR		0x1480
#define MC_TXN_OVERRIDE_CONFIG_TSECSWR		0x12a8
#define MC_TXN_OVERRIDE_CONFIG_GPUSWR		0x12c8
#define MC_TXN_OVERRIDE_CONFIG_SATAR		0x10f8
#define MC_TXN_OVERRIDE_CONFIG_XUSB_HOSTW	0x1258
#define MC_TXN_OVERRIDE_CONFIG_TSECSWRB		0x1438
#define MC_TXN_OVERRIDE_CONFIG_GPUSRD2		0x1440
#define MC_TXN_OVERRIDE_CONFIG_SCEDMAR		0x14e8
#define MC_TXN_OVERRIDE_CONFIG_GPUSWR2		0x1448
#define MC_TXN_OVERRIDE_CONFIG_AONDMAW		0x14d0
#define MC_TXN_OVERRIDE_CONFIG_APEDMAW		0x1500
#define MC_TXN_OVERRIDE_CONFIG_AONW		0x14c0
#define MC_TXN_OVERRIDE_CONFIG_HOST1XDMAR	0x10b0
#define MC_TXN_OVERRIDE_CONFIG_ETRR		0x1420
#define MC_TXN_OVERRIDE_CONFIG_SESWR		0x1408
#define MC_TXN_OVERRIDE_CONFIG_NVJPGSRD		0x13f0
#define MC_TXN_OVERRIDE_CONFIG_NVDECSRD		0x13c0
#define MC_TXN_OVERRIDE_CONFIG_TSECSRDB		0x1430
#define MC_TXN_OVERRIDE_CONFIG_BPMPDMAW		0x14b0
#define MC_TXN_OVERRIDE_CONFIG_APER		0x13d0
#define MC_TXN_OVERRIDE_CONFIG_NVDECSRD1	0x1518
#define MC_TXN_OVERRIDE_CONFIG_XUSB_HOSTR	0x1250
#define MC_TXN_OVERRIDE_CONFIG_ISPWA		0x1230
#define MC_TXN_OVERRIDE_CONFIG_SESRD		0x1400
#define MC_TXN_OVERRIDE_CONFIG_SCER		0x14d8
#define MC_TXN_OVERRIDE_CONFIG_AONR		0x14b8
#define MC_TXN_OVERRIDE_CONFIG_MPCORER		0x1138
#define MC_TXN_OVERRIDE_CONFIG_SDMMCWA		0x1320
#define MC_TXN_OVERRIDE_CONFIG_HDAW		0x11a8
#define MC_TXN_OVERRIDE_CONFIG_NVDECSWR		0x13c8
#define MC_TXN_OVERRIDE_CONFIG_UFSHCW		0x1488
#define MC_TXN_OVERRIDE_CONFIG_AONDMAR		0x14c8
#define MC_TXN_OVERRIDE_CONFIG_SATAW		0x11e8
#define MC_TXN_OVERRIDE_CONFIG_ETRW		0x1428
#define MC_TXN_OVERRIDE_CONFIG_VICSWR		0x1368
#define MC_TXN_OVERRIDE_CONFIG_NVENCSWR		0x1158
#define MC_TXN_OVERRIDE_CONFIG_SDMMCWAB		0x1338
#define MC_TXN_OVERRIDE_CONFIG_SDMMCRA		0x1300
#define MC_TXN_OVERRIDE_CONFIG_NVDISPLAYR1	0x1508
#define MC_TXN_OVERRIDE_CONFIG_ISPWB		0x1238
#define MC_TXN_OVERRIDE_CONFIG_BPMPR		0x1498
#define MC_TXN_OVERRIDE_CONFIG_APEW		0x13d8
#define MC_TXN_OVERRIDE_CONFIG_SDMMCR		0x1310
#define MC_TXN_OVERRIDE_CONFIG_XUSB_DEVW	0x1268
#define MC_TXN_OVERRIDE_CONFIG_TSECSRD		0x12a0
#define MC_TXN_OVERRIDE_CONFIG_SCEW		0x14e0
#define MC_TXN_OVERRIDE_CONFIG_MIU0R		0x1530
#define MC_TXN_OVERRIDE_CONFIG_MIU0W		0x1538
#define MC_TXN_OVERRIDE_CONFIG_MIU1R		0x1540
#define MC_TXN_OVERRIDE_CONFIG_MIU1W		0x1548
#define MC_TXN_OVERRIDE_CONFIG_MIU2R		0x1570
#define MC_TXN_OVERRIDE_CONFIG_MIU2W		0x1578
#define MC_TXN_OVERRIDE_CONFIG_MIU3R		0x1580
#define MC_TXN_OVERRIDE_CONFIG_MIU3W		0x158C
#define MC_TXN_OVERRIDE_CONFIG_VIFALR		0x15E4
#define MC_TXN_OVERRIDE_CONFIG_VIFALW		0x15EC
#define MC_TXN_OVERRIDE_CONFIG_DLA0RDA		0x15F4
#define MC_TXN_OVERRIDE_CONFIG_DLA0FALRDB	0x15FC
#define MC_TXN_OVERRIDE_CONFIG_DLA0WRA		0x1604
#define MC_TXN_OVERRIDE_CONFIG_DLA0FALWRB	0x160C
#define MC_TXN_OVERRIDE_CONFIG_DLA1RDA		0x1614
#define MC_TXN_OVERRIDE_CONFIG_DLA1FALRDB	0x161C
#define MC_TXN_OVERRIDE_CONFIG_DLA1WRA		0x1624
#define MC_TXN_OVERRIDE_CONFIG_DLA1FALWRB	0x162C
#define MC_TXN_OVERRIDE_CONFIG_PVA0RDA		0x1634
#define MC_TXN_OVERRIDE_CONFIG_PVA0RDB		0x163C
#define MC_TXN_OVERRIDE_CONFIG_PVA0RDC		0x1644
#define MC_TXN_OVERRIDE_CONFIG_PVA0WRA		0x164C
#define MC_TXN_OVERRIDE_CONFIG_PVA0WRB		0x1654
#define MC_TXN_OVERRIDE_CONFIG_PVA0WRC		0x165C
#define MC_TXN_OVERRIDE_CONFIG_PVA1RDA		0x1664
#define MC_TXN_OVERRIDE_CONFIG_PVA1RDB		0x166C
#define MC_TXN_OVERRIDE_CONFIG_PVA1RDC		0x1674
#define MC_TXN_OVERRIDE_CONFIG_PVA1WRA		0x167C
#define MC_TXN_OVERRIDE_CONFIG_PVA1WRB		0x1684
#define MC_TXN_OVERRIDE_CONFIG_PVA1WRC		0x168C
#define MC_TXN_OVERRIDE_CONFIG_RCER		0x1694
#define MC_TXN_OVERRIDE_CONFIG_RCEW		0x169C
#define MC_TXN_OVERRIDE_CONFIG_RCEDMAR		0x16A4
#define MC_TXN_OVERRIDE_CONFIG_RCEDMAW		0x16AC
#define MC_TXN_OVERRIDE_CONFIG_NVENC1SRD	0x16B4
#define MC_TXN_OVERRIDE_CONFIG_NVENC1SWR	0x16BC
#define MC_TXN_OVERRIDE_CONFIG_PCIE0R		0x16C4
#define MC_TXN_OVERRIDE_CONFIG_PCIE0W		0x16CC
#define MC_TXN_OVERRIDE_CONFIG_PCIE1R		0x16D4
#define MC_TXN_OVERRIDE_CONFIG_PCIE1W		0x16DC
#define MC_TXN_OVERRIDE_CONFIG_PCIE2AR		0x16E4
#define MC_TXN_OVERRIDE_CONFIG_PCIE2AW		0x16EC
#define MC_TXN_OVERRIDE_CONFIG_PCIE3R		0x16F4
#define MC_TXN_OVERRIDE_CONFIG_PCIE3W		0x16FC
#define MC_TXN_OVERRIDE_CONFIG_PCIE4R		0x1704
#define MC_TXN_OVERRIDE_CONFIG_PCIE4W		0x170C
#define MC_TXN_OVERRIDE_CONFIG_PCIE5R		0x1714
#define MC_TXN_OVERRIDE_CONFIG_PCIE5W		0x171C
#define MC_TXN_OVERRIDE_CONFIG_ISPFALW		0x1724
#define MC_TXN_OVERRIDE_CONFIG_DLA0RDA1		0x174C
#define MC_TXN_OVERRIDE_CONFIG_DLA1RDA1		0x1754
#define MC_TXN_OVERRIDE_CONFIG_PVA0RDA1		0x175C
#define MC_TXN_OVERRIDE_CONFIG_PVA0RDB1		0x1764
#define MC_TXN_OVERRIDE_CONFIG_PVA1RDA1		0x176C
#define MC_TXN_OVERRIDE_CONFIG_PVA1RDB1		0x1774
#define MC_TXN_OVERRIDE_CONFIG_PCIE5R1		0x177C
#define MC_TXN_OVERRIDE_CONFIG_NVENCSRD1	0x1784
#define MC_TXN_OVERRIDE_CONFIG_NVENC1SRD1	0x178C
#define MC_TXN_OVERRIDE_CONFIG_ISPRA1		0x1794
#define MC_TXN_OVERRIDE_CONFIG_PCIE0R1		0x179C
#define MC_TXN_OVERRIDE_CONFIG_NVDEC1SRD	0x17CC
#define MC_TXN_OVERRIDE_CONFIG_NVDEC1SRD1	0x17D4
#define MC_TXN_OVERRIDE_CONFIG_NVDEC1SWR	0x17DC

/*******************************************************************************
 * Array to hold stream_id override config register offsets
 ******************************************************************************/
const static uint32_t mc_streamid_override_regs[] = {
	MC_STREAMID_OVERRIDE_CFG_HDAR,
	MC_STREAMID_OVERRIDE_CFG_HOST1XDMAR,
	MC_STREAMID_OVERRIDE_CFG_NVENCSRD,
	MC_STREAMID_OVERRIDE_CFG_SATAR,
	MC_STREAMID_OVERRIDE_CFG_NVENCSWR,
	MC_STREAMID_OVERRIDE_CFG_HDAW,
	MC_STREAMID_OVERRIDE_CFG_SATAW,
	MC_STREAMID_OVERRIDE_CFG_ISPRA,
	MC_STREAMID_OVERRIDE_CFG_ISPFALR,
	MC_STREAMID_OVERRIDE_CFG_ISPWA,
	MC_STREAMID_OVERRIDE_CFG_ISPWB,
	MC_STREAMID_OVERRIDE_CFG_XUSB_HOSTR,
	MC_STREAMID_OVERRIDE_CFG_XUSB_HOSTW,
	MC_STREAMID_OVERRIDE_CFG_XUSB_DEVR,
	MC_STREAMID_OVERRIDE_CFG_XUSB_DEVW,
	MC_STREAMID_OVERRIDE_CFG_TSECSRD,
	MC_STREAMID_OVERRIDE_CFG_TSECSWR,
	MC_STREAMID_OVERRIDE_CFG_SDMMCRA,
	MC_STREAMID_OVERRIDE_CFG_SDMMCR,
	MC_STREAMID_OVERRIDE_CFG_SDMMCRAB,
	MC_STREAMID_OVERRIDE_CFG_SDMMCWA,
	MC_STREAMID_OVERRIDE_CFG_SDMMCW,
	MC_STREAMID_OVERRIDE_CFG_SDMMCWAB,
	MC_STREAMID_OVERRIDE_CFG_VICSRD,
	MC_STREAMID_OVERRIDE_CFG_VICSWR,
	MC_STREAMID_OVERRIDE_CFG_VIW,
	MC_STREAMID_OVERRIDE_CFG_NVDECSRD,
	MC_STREAMID_OVERRIDE_CFG_NVDECSWR,
	MC_STREAMID_OVERRIDE_CFG_APER,
	MC_STREAMID_OVERRIDE_CFG_APEW,
	MC_STREAMID_OVERRIDE_CFG_NVJPGSRD,
	MC_STREAMID_OVERRIDE_CFG_NVJPGSWR,
	MC_STREAMID_OVERRIDE_CFG_SESRD,
	MC_STREAMID_OVERRIDE_CFG_SESWR,
	MC_STREAMID_OVERRIDE_CFG_AXIAPR,
	MC_STREAMID_OVERRIDE_CFG_AXIAPW,
	MC_STREAMID_OVERRIDE_CFG_ETRR,
	MC_STREAMID_OVERRIDE_CFG_ETRW,
	MC_STREAMID_OVERRIDE_CFG_TSECSRDB,
	MC_STREAMID_OVERRIDE_CFG_TSECSWRB,
	MC_STREAMID_OVERRIDE_CFG_AXISR,
	MC_STREAMID_OVERRIDE_CFG_AXISW,
	MC_STREAMID_OVERRIDE_CFG_EQOSR,
	MC_STREAMID_OVERRIDE_CFG_EQOSW,
	MC_STREAMID_OVERRIDE_CFG_UFSHCR,
	MC_STREAMID_OVERRIDE_CFG_UFSHCW,
	MC_STREAMID_OVERRIDE_CFG_NVDISPLAYR,
	MC_STREAMID_OVERRIDE_CFG_BPMPR,
	MC_STREAMID_OVERRIDE_CFG_BPMPW,
	MC_STREAMID_OVERRIDE_CFG_BPMPDMAR,
	MC_STREAMID_OVERRIDE_CFG_BPMPDMAW,
	MC_STREAMID_OVERRIDE_CFG_AONR,
	MC_STREAMID_OVERRIDE_CFG_AONW,
	MC_STREAMID_OVERRIDE_CFG_AONDMAR,
	MC_STREAMID_OVERRIDE_CFG_AONDMAW,
	MC_STREAMID_OVERRIDE_CFG_SCER,
	MC_STREAMID_OVERRIDE_CFG_SCEW,
	MC_STREAMID_OVERRIDE_CFG_SCEDMAR,
	MC_STREAMID_OVERRIDE_CFG_SCEDMAW,
	MC_STREAMID_OVERRIDE_CFG_APEDMAR,
	MC_STREAMID_OVERRIDE_CFG_APEDMAW,
	MC_STREAMID_OVERRIDE_CFG_NVDISPLAYR1,
	MC_STREAMID_OVERRIDE_CFG_VICSRD1,
	MC_STREAMID_OVERRIDE_CFG_NVDECSRD1,
	MC_STREAMID_OVERRIDE_CFG_VIFALR,
	MC_STREAMID_OVERRIDE_CFG_VIFALW,
	MC_STREAMID_OVERRIDE_CFG_DLA0RDA,
	MC_STREAMID_OVERRIDE_CFG_DLA0FALRDB,
	MC_STREAMID_OVERRIDE_CFG_DLA0WRA,
	MC_STREAMID_OVERRIDE_CFG_DLA0FALWRB,
	MC_STREAMID_OVERRIDE_CFG_DLA1RDA,
	MC_STREAMID_OVERRIDE_CFG_DLA1FALRDB,
	MC_STREAMID_OVERRIDE_CFG_DLA1WRA,
	MC_STREAMID_OVERRIDE_CFG_DLA1FALWRB,
	MC_STREAMID_OVERRIDE_CFG_PVA0RDA,
	MC_STREAMID_OVERRIDE_CFG_PVA0RDB,
	MC_STREAMID_OVERRIDE_CFG_PVA0RDC,
	MC_STREAMID_OVERRIDE_CFG_PVA0WRA,
	MC_STREAMID_OVERRIDE_CFG_PVA0WRB,
	MC_STREAMID_OVERRIDE_CFG_PVA0WRC,
	MC_STREAMID_OVERRIDE_CFG_PVA1RDA,
	MC_STREAMID_OVERRIDE_CFG_PVA1RDB,
	MC_STREAMID_OVERRIDE_CFG_PVA1RDC,
	MC_STREAMID_OVERRIDE_CFG_PVA1WRA,
	MC_STREAMID_OVERRIDE_CFG_PVA1WRB,
	MC_STREAMID_OVERRIDE_CFG_PVA1WRC,
	MC_STREAMID_OVERRIDE_CFG_RCER,
	MC_STREAMID_OVERRIDE_CFG_RCEW,
	MC_STREAMID_OVERRIDE_CFG_RCEDMAR,
	MC_STREAMID_OVERRIDE_CFG_RCEDMAW,
	MC_STREAMID_OVERRIDE_CFG_NVENC1SRD,
	MC_STREAMID_OVERRIDE_CFG_NVENC1SWR,
	MC_STREAMID_OVERRIDE_CFG_PCIE0R,
	MC_STREAMID_OVERRIDE_CFG_PCIE0W,
	MC_STREAMID_OVERRIDE_CFG_PCIE1R,
	MC_STREAMID_OVERRIDE_CFG_PCIE1W,
	MC_STREAMID_OVERRIDE_CFG_PCIE2AR,
	MC_STREAMID_OVERRIDE_CFG_PCIE2AW,
	MC_STREAMID_OVERRIDE_CFG_PCIE3R,
	MC_STREAMID_OVERRIDE_CFG_PCIE3W,
	MC_STREAMID_OVERRIDE_CFG_PCIE4R,
	MC_STREAMID_OVERRIDE_CFG_PCIE4W,
	MC_STREAMID_OVERRIDE_CFG_PCIE5R,
	MC_STREAMID_OVERRIDE_CFG_PCIE5W,
	MC_STREAMID_OVERRIDE_CFG_ISPFALW,
	MC_STREAMID_OVERRIDE_CFG_DLA0RDA1,
	MC_STREAMID_OVERRIDE_CFG_DLA1RDA1,
	MC_STREAMID_OVERRIDE_CFG_PVA0RDA1,
	MC_STREAMID_OVERRIDE_CFG_PVA0RDB1,
	MC_STREAMID_OVERRIDE_CFG_PVA1RDA1,
	MC_STREAMID_OVERRIDE_CFG_PVA1RDB1,
	MC_STREAMID_OVERRIDE_CFG_PCIE5R1,
	MC_STREAMID_OVERRIDE_CFG_NVENCSRD1,
	MC_STREAMID_OVERRIDE_CFG_NVENC1SRD1,
	MC_STREAMID_OVERRIDE_CFG_ISPRA1,
	MC_STREAMID_OVERRIDE_CFG_MIU0R,
	MC_STREAMID_OVERRIDE_CFG_MIU0W,
	MC_STREAMID_OVERRIDE_CFG_MIU1R,
	MC_STREAMID_OVERRIDE_CFG_MIU1W,
	MC_STREAMID_OVERRIDE_CFG_MIU2R,
	MC_STREAMID_OVERRIDE_CFG_MIU2W,
	MC_STREAMID_OVERRIDE_CFG_MIU3R,
	MC_STREAMID_OVERRIDE_CFG_MIU3W
};

/*******************************************************************************
 * Array to hold the security configs for stream IDs
 ******************************************************************************/
const static mc_streamid_security_cfg_t mc_streamid_sec_cfgs[] = {
	mc_make_sec_cfg(HDAR, NON_SECURE, OVERRIDE, ENABLE),
	mc_make_sec_cfg(HOST1XDMAR, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(NVENCSRD, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(SATAR, NON_SECURE, OVERRIDE, ENABLE),
	mc_make_sec_cfg(NVENCSWR, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(HDAW, NON_SECURE, OVERRIDE, ENABLE),
	mc_make_sec_cfg(SATAW, NON_SECURE, OVERRIDE, ENABLE),
	mc_make_sec_cfg(ISPRA, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(ISPFALR, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(ISPWA, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(ISPWB, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(XUSB_HOSTR, NON_SECURE, OVERRIDE, ENABLE),
	mc_make_sec_cfg(XUSB_HOSTW, NON_SECURE, OVERRIDE, ENABLE),
	mc_make_sec_cfg(XUSB_DEVR, NON_SECURE, OVERRIDE, ENABLE),
	mc_make_sec_cfg(XUSB_DEVW, NON_SECURE, OVERRIDE, ENABLE),
	mc_make_sec_cfg(TSECSRD, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(TSECSWR, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(SDMMCRA, NON_SECURE, OVERRIDE, ENABLE),
	mc_make_sec_cfg(SDMMCR, NON_SECURE, OVERRIDE, ENABLE),
	mc_make_sec_cfg(SDMMCRAB, NON_SECURE, OVERRIDE, ENABLE),
	mc_make_sec_cfg(SDMMCWA, NON_SECURE, OVERRIDE, ENABLE),
	mc_make_sec_cfg(SDMMCW, NON_SECURE, OVERRIDE, ENABLE),
	mc_make_sec_cfg(SDMMCWAB, NON_SECURE, OVERRIDE, ENABLE),
	mc_make_sec_cfg(VICSRD, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(VICSWR, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(VIW, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(NVDECSRD, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(NVDECSWR, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(APER, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(APEW, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(NVJPGSRD, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(NVJPGSWR, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(SESRD, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(SESWR, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(AXIAPR, NON_SECURE, OVERRIDE, ENABLE),
	mc_make_sec_cfg(AXIAPW, NON_SECURE, OVERRIDE, ENABLE),
	mc_make_sec_cfg(ETRR, NON_SECURE, OVERRIDE, ENABLE),
	mc_make_sec_cfg(ETRW, NON_SECURE, OVERRIDE, ENABLE),
	mc_make_sec_cfg(TSECSRDB, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(TSECSWRB, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(AXISR, SECURE, NO_OVERRIDE, DISABLE),
	mc_make_sec_cfg(AXISW, SECURE, NO_OVERRIDE, DISABLE),
	mc_make_sec_cfg(EQOSR, NON_SECURE, OVERRIDE, ENABLE),
	mc_make_sec_cfg(EQOSW, NON_SECURE, OVERRIDE, ENABLE),
	mc_make_sec_cfg(UFSHCR, NON_SECURE, OVERRIDE, ENABLE),
	mc_make_sec_cfg(UFSHCW, NON_SECURE, OVERRIDE, ENABLE),
	mc_make_sec_cfg(NVDISPLAYR, NON_SECURE, OVERRIDE, ENABLE),
	mc_make_sec_cfg(BPMPR, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(BPMPW, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(BPMPDMAR, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(BPMPDMAW, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(AONR, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(AONW, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(AONDMAR, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(AONDMAW, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(SCER, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(SCEW, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(SCEDMAR, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(SCEDMAW, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(APEDMAR, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(APEDMAW, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(NVDISPLAYR1, NON_SECURE, OVERRIDE, ENABLE),
	mc_make_sec_cfg(VICSRD1, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(NVDECSRD1, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(VIFALR, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(VIFALW, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(DLA0RDA, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(DLA0FALRDB, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(DLA0WRA, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(DLA0FALWRB, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(DLA1RDA, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(DLA1FALRDB, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(DLA1WRA, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(DLA1FALWRB, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(PVA0RDA, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(PVA0RDB, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(PVA0RDC, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(PVA0WRA, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(PVA0WRB, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(PVA0WRC, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(PVA1RDA, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(PVA1RDB, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(PVA1RDC, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(PVA1WRA, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(PVA1WRB, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(PVA1WRC, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(RCER, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(RCEW, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(RCEDMAR, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(RCEDMAW, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(NVENC1SRD, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(NVENC1SWR, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(PCIE0R, NON_SECURE, OVERRIDE, ENABLE),
	mc_make_sec_cfg(PCIE0W, NON_SECURE, OVERRIDE, ENABLE),
	mc_make_sec_cfg(PCIE1R, NON_SECURE, OVERRIDE, ENABLE),
	mc_make_sec_cfg(PCIE1W, NON_SECURE, OVERRIDE, ENABLE),
	mc_make_sec_cfg(PCIE2AR, NON_SECURE, OVERRIDE, ENABLE),
	mc_make_sec_cfg(PCIE2AW, NON_SECURE, OVERRIDE, ENABLE),
	mc_make_sec_cfg(PCIE3R, NON_SECURE, OVERRIDE, ENABLE),
	mc_make_sec_cfg(PCIE3W, NON_SECURE, OVERRIDE, ENABLE),
	mc_make_sec_cfg(PCIE4R, NON_SECURE, OVERRIDE, ENABLE),
	mc_make_sec_cfg(PCIE4W, NON_SECURE, OVERRIDE, ENABLE),
	mc_make_sec_cfg(PCIE5R, NON_SECURE, OVERRIDE, ENABLE),
	mc_make_sec_cfg(PCIE5W, NON_SECURE, OVERRIDE, ENABLE),
	mc_make_sec_cfg(ISPFALW, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(DLA0RDA1, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(DLA1RDA1, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(PVA0RDA1, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(PVA0RDB1, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(PVA1RDA1, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(PVA1RDB1, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(PCIE5R1, NON_SECURE, OVERRIDE, ENABLE),
	mc_make_sec_cfg(NVENCSRD1, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(NVENC1SRD1, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(ISPRA1, NON_SECURE, NO_OVERRIDE, ENABLE),
	mc_make_sec_cfg(MIU0R, NON_SECURE, OVERRIDE, ENABLE),
	mc_make_sec_cfg(MIU0W, NON_SECURE, OVERRIDE, ENABLE),
	mc_make_sec_cfg(MIU1R, NON_SECURE, OVERRIDE, ENABLE),
	mc_make_sec_cfg(MIU1W, NON_SECURE, OVERRIDE, ENABLE),
	mc_make_sec_cfg(MIU2R, NON_SECURE, OVERRIDE, ENABLE),
	mc_make_sec_cfg(MIU2W, NON_SECURE, OVERRIDE, ENABLE),
	mc_make_sec_cfg(MIU3R, NON_SECURE, OVERRIDE, ENABLE),
	mc_make_sec_cfg(MIU3W, NON_SECURE, OVERRIDE, ENABLE),
};

/*******************************************************************************
 * Array to hold the transaction override configs
 ******************************************************************************/
const static mc_txn_override_cfg_t mc_txn_override_cfgs[] = {
	mc_make_txn_override_cfg(NVENCSWR, CGID_TAG_ADR),
	mc_make_txn_override_cfg(HDAW, CGID_TAG_ADR),
	mc_make_txn_override_cfg(SATAW, CGID_TAG_ADR),
	mc_make_txn_override_cfg(ISPWB, CGID_TAG_ADR),
	mc_make_txn_override_cfg(XUSB_HOSTW, CGID_TAG_ADR),
	mc_make_txn_override_cfg(XUSB_DEVW, CGID_TAG_ADR),
	mc_make_txn_override_cfg(TSECSWR, CGID_TAG_ADR),
	mc_make_txn_override_cfg(SDMMCWA, CGID_TAG_ADR),
	mc_make_txn_override_cfg(SDMMCW, CGID_TAG_ADR),
	mc_make_txn_override_cfg(SDMMCWAB, CGID_TAG_ADR),
	mc_make_txn_override_cfg(VICSWR, CGID_TAG_ADR),
	mc_make_txn_override_cfg(NVDECSWR, CGID_TAG_ADR),
	mc_make_txn_override_cfg(APEW, CGID_TAG_ADR),
	mc_make_txn_override_cfg(NVJPGSWR, CGID_TAG_ADR),
	mc_make_txn_override_cfg(SESWR, CGID_TAG_ADR),
	mc_make_txn_override_cfg(ETRW, CGID_TAG_ADR),
	mc_make_txn_override_cfg(TSECSWRB, CGID_TAG_ADR),
	mc_make_txn_override_cfg(AXISW, CGID_TAG_ADR),
	mc_make_txn_override_cfg(EQOSW, CGID_TAG_ADR),
	mc_make_txn_override_cfg(UFSHCW, CGID_TAG_ADR),
	mc_make_txn_override_cfg(BPMPW, CGID_TAG_ADR),
	mc_make_txn_override_cfg(BPMPDMAW, CGID_TAG_ADR),
	mc_make_txn_override_cfg(AONW, CGID_TAG_ADR),
	mc_make_txn_override_cfg(AONDMAW, CGID_TAG_ADR),
	mc_make_txn_override_cfg(SCEW, CGID_TAG_ADR),
	mc_make_txn_override_cfg(SCEDMAW, CGID_TAG_ADR),
};

#endif //__MEMCTRL_PLAT_CONFIG_H
