#!/usr/bin/env python
import os, sys, string
try:
   from cStringIO import StringIO
except ImportError:
   try:
      from StringIO import StringIO
   except ImportError:
      from io import StringIO

ANY=1
COPY=2
SKIP=3
SKIPONE=4
COPYDEFINE=5

state = ANY
static = 0

file = open(sys.argv[1])
name = sys.argv[1][:-2]

out = StringIO()

selfheader = '#include "' + name + '.h"'

out.write( "/* Do not edit this file. It was automatically generated. */\n" )
out.write( "\n" )

out.write( "#ifndef HEADER_" + os.path.basename(name) + "\n")
out.write( "#define HEADER_" + os.path.basename(name) + "\n")
is_blank = False
for line in file.readlines():
   line = line[:-1]
   if state == ANY:
      if line == '/*{':
         state = COPY
      elif line == selfheader:
         pass
      elif line.find("#include") == 0:
         pass
      elif line.find("htop - ") == 0 and line[-2:] == ".c":
         out.write(line[:-2] + ".h\n")
      elif line.find("static ") != -1:
         if line[-1] == "{":
            state = SKIP
            static = 1
         else:
            state = SKIPONE
      elif len(line) > 1:
         static = 0
         equals = line.find(" = ")
         if line[:7] == "#define":
            if line[-1:] == "\\":
               state = COPYDEFINE
            out.write( line + "\n")
         elif line[-3:] == "= {":
            out.write( "extern " + line[:-4] + ";\n" )
            state = SKIP
         elif equals != -1:
            out.write("extern " + line[:equals] + ";\n" )
         elif line.startswith("typedef struct"):
            state = SKIP
         elif line[-1] == "{":
            out.write( line[:-2].replace("inline", "extern") + ";\n" )
            state = SKIP
         else:
            out.write( line + "\n" )
         is_blank = False
      elif line == "":
         if not is_blank:
            out.write( line + "\n")
         is_blank = True
      else:
         out.write( line  + "\n")
         is_blank = False
   elif state == COPYDEFINE:
      is_blank = False
      out.write( line + "\n")
      if line[-1:] != "\\":
         state = ANY
   elif state == COPY:
      is_blank = False
      if line == "}*/":
         state = ANY
      else:
         out.write( line + "\n")
   elif state == SKIP:
      is_blank = False
      if len(line) >= 1 and line[0] == "}":
         if static == 1:
            state = SKIPONE
         else:
            state = ANY
         static = 0
   elif state == SKIPONE:
      is_blank = False
      state = ANY

out.write( "\n" )
out.write( "#endif\n" )

# only write a new .h file if something changed.
# This prevents a lot of recompilation during development
out.seek(0)
try:
   with open(name + ".h", "r") as orig:
      origcontents = orig.readlines()
except:
   origcontents = ""
if origcontents != out.readlines():
   with open(name + ".h", "w") as new:
      print("Writing "+name+".h")
      new.write(out.getvalue())
out.close()
