/* Do not edit this file. It was automatically generated. */

#ifndef HEADER_Settings
#define HEADER_Settings
/*
htop - Settings.h
(C) 2004-2011 Hisham H. Muhammad
Released under the GNU GPL, see the COPYING file
in the source distribution for its full text.
*/

#define DEFAULT_DELAY 15

#include "Process.h"
#include <stdbool.h>

#ifdef HAVE_LUA
#include <lua.h>
#include <lualib.h>
#include <lauxlib.h>
#endif

typedef struct {
   int len;
   char** names;
   int* modes;
} MeterColumnSettings;

typedef struct {
   char* name;
   ProcessField* fields;
   int flags;
   int direction;
   ProcessField sortKey;
   bool treeView;
} ScreenSettings;

typedef struct Settings_ {
   char* filename;
   
   #ifdef HAVE_LUA
   lua_State* L;
   #endif
   
   MeterColumnSettings meterColumns[2];

   char** plugins;
   int nPlugins;

   ScreenSettings** screens;
   unsigned int nScreens;
   unsigned int ssIndex;
   ScreenSettings* ss;

   int flags;
   int colorScheme;
   int delay;

   int cpuCount;

   bool countCPUsFromZero;
   bool detailedCPUTime;
   bool showProgramPath;
   bool hideThreads;
   bool shadowOtherUsers;
   bool showThreadNames;
   bool hideKernelThreads;
   bool hideUserlandThreads;
   bool highlightBaseName;
   bool highlightMegabytes;
   bool highlightThreads;
   bool updateProcessNames;
   bool accountGuestInCPUMeter;
   bool headerMargin;

   bool changed;
} Settings;

#ifndef Settings_cpuId
#define Settings_cpuId(settings, cpu) ((settings)->countCPUsFromZero ? (cpu) : (cpu)+1)
#endif


/*

*/

void Settings_delete(Settings* this);

ScreenSettings* Settings_newScreen(Settings* this, const char* name, const char* line);

bool Settings_write(Settings* this);

Settings* Settings_new(int cpuCount);

void ScreenSettings_invertSortOrder(ScreenSettings* this);

#endif
