/* Do not edit this file. It was automatically generated. */

#ifndef HEADER_FreeBSDProcess
#define HEADER_FreeBSDProcess
/*
htop - FreeBSDProcess.h
(C) 2015 Hisham H. Muhammad
Released under the GNU GPL, see the COPYING file
in the source distribution for its full text.
*/


#include <kvm.h>
#include <sys/param.h>
#include <sys/jail.h>
#include <sys/uio.h>
#include <sys/resource.h>

#define JAIL_ERRMSGLEN	1024
char jail_errmsg[JAIL_ERRMSGLEN];

typedef enum FreeBSDProcessFields {
   // Add platform-specific fields here, with ids >= 100
   JID   = 100,
   JAIL  = 101,
   LAST_PROCESSFIELD = 102,
} FreeBSDProcessField;

typedef struct FreeBSDProcess_ {
   Process super;
   int   kernel;
   int   jid;
   char* jname;
} FreeBSDProcess;

typedef struct FreeBSDProcessScanData_ {
   int pageSizeKb;
   int kernelFScale;
   struct kinfo_proc* kproc;
} FreeBSDProcessScanData;


extern ObjectClass FreeBSDProcess_class;

extern ProcessFieldData Process_fields[];

extern ProcessPidColumn Process_pidColumns[];

Process* Process_new(Settings* settings);

void Process_delete(Object* cast);

void Process_writeField(Process* this, RichString* str, ProcessField field);

long FreeBSDProcess_compare(const void* v1, const void* v2);

char* FreeBSDProcess_readJailName(struct kinfo_proc* kproc);

char* FreeBSDProcess_readProcessName(kvm_t* kd, struct kinfo_proc* kproc, int* basenameEnd);

bool Process_update(Process* proc, bool isNew, ProcessList* pl, ProcessScanData* psd);

#endif
